/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.uno;

import com.sun.star.uno.ITypeDescription;
import com.sun.star.uno.TypeClass;
import java.util.HashMap;

public class Type {
    private static final String[] __typeClassToTypeName = new String[]{"void", "char", "boolean", "byte", "short", "unsigned short", "long", "unsigned long", "hyper", "unsigned hyper", "float", "double", "string", "type", "any"};
    private static final HashMap __javaClassToTypeName = new HashMap();
    private static final HashMap __typeNameToTypeClass = new HashMap();
    public static final Type VOID;
    public static final Type CHAR;
    public static final Type BOOLEAN;
    public static final Type BYTE;
    public static final Type SHORT;
    public static final Type UNSIGNED_SHORT;
    public static final Type LONG;
    public static final Type UNSIGNED_LONG;
    public static final Type HYPER;
    public static final Type UNSIGNED_HYPER;
    public static final Type FLOAT;
    public static final Type DOUBLE;
    public static final Type STRING;
    public static final Type TYPE;
    public static final Type ANY;
    protected TypeClass _typeClass;
    protected String _typeName;
    protected Class _class;
    protected ITypeDescription _iTypeDescription;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$star$uno$Type;
    static /* synthetic */ Class class$com$sun$star$uno$Any;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$sun$star$uno$XInterface;
    static /* synthetic */ Class class$com$sun$star$uno$Enum;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$com$sun$star$uno$Union;

    public Type() {
        this(Void.TYPE);
    }

    public Type(String string, TypeClass typeClass) {
        this._typeClass = typeClass;
        this._typeName = string;
    }

    public Type(Class clazz) {
        this._class = clazz;
        this._typeName = (String)__javaClassToTypeName.get(clazz);
        if (this._typeName != null) {
            this._typeClass = (TypeClass)__typeNameToTypeClass.get(this._typeName);
        } else if ((class$com$sun$star$uno$XInterface == null ? (class$com$sun$star$uno$XInterface = Type.class$("com.sun.star.uno.XInterface")) : class$com$sun$star$uno$XInterface).isAssignableFrom(clazz)) {
            this._typeClass = TypeClass.INTERFACE;
            this._typeName = clazz.isInterface() ? clazz.getName() : (class$com$sun$star$uno$XInterface == null ? (class$com$sun$star$uno$XInterface = Type.class$("com.sun.star.uno.XInterface")) : class$com$sun$star$uno$XInterface).getName();
        } else if (clazz.isArray()) {
            this._typeClass = TypeClass.SEQUENCE;
            this._typeName = "[]" + new Type(this._class.getComponentType()).getTypeName();
        } else if ((class$com$sun$star$uno$Enum == null ? (class$com$sun$star$uno$Enum = Type.class$("com.sun.star.uno.Enum")) : class$com$sun$star$uno$Enum).isAssignableFrom(clazz)) {
            this._typeClass = TypeClass.ENUM;
            this._typeName = clazz.getName();
        } else if ((class$java$lang$Throwable == null ? (class$java$lang$Throwable = Type.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(clazz)) {
            this._typeClass = TypeClass.EXCEPTION;
            this._typeName = clazz.getName();
        } else if ((class$com$sun$star$uno$Union == null ? (class$com$sun$star$uno$Union = Type.class$("com.sun.star.uno.Union")) : class$com$sun$star$uno$Union).isAssignableFrom(clazz)) {
            this._typeClass = TypeClass.UNION;
            this._typeName = clazz.getName();
        } else {
            this._typeClass = TypeClass.STRUCT;
            this._typeName = clazz.getName();
        }
    }

    public Type(ITypeDescription iTypeDescription) {
        this._typeName = iTypeDescription.getTypeName();
        this._typeClass = iTypeDescription.getTypeClass();
        this._iTypeDescription = iTypeDescription;
    }

    public Type(String string) {
        this._typeClass = (TypeClass)__typeNameToTypeClass.get(string);
        if (this._typeClass == null) {
            this._typeClass = TypeClass.UNKNOWN;
        }
        this._typeName = string;
    }

    public Type(TypeClass typeClass) {
        if (!Type.__isTypeClassPrimitive(typeClass)) {
            throw new IllegalArgumentException(typeClass + " is not primitive");
        }
        this._typeClass = typeClass;
        this._typeName = __typeClassToTypeName[typeClass.getValue()];
    }

    public TypeClass getTypeClass() {
        return this._typeClass;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public Class getZClass() {
        if (this._class != null) {
            return this._class;
        }
        switch (this._typeClass.getValue()) {
            case 0: {
                return Void.TYPE;
            }
            case 2: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 6: {
                return Integer.TYPE;
            }
            case 8: {
                return Long.TYPE;
            }
            case 10: {
                return Float.TYPE;
            }
            case 11: {
                return Double.TYPE;
            }
            case 1: {
                return Character.TYPE;
            }
            case 12: {
                return class$java$lang$String == null ? (class$java$lang$String = Type.class$("java.lang.String")) : class$java$lang$String;
            }
            case 13: {
                return class$com$sun$star$uno$Type == null ? (class$com$sun$star$uno$Type = Type.class$("com.sun.star.uno.Type")) : class$com$sun$star$uno$Type;
            }
            case 14: {
                return class$java$lang$Object == null ? (class$java$lang$Object = Type.class$("java.lang.Object")) : class$java$lang$Object;
            }
            case 20: {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (this._typeName.startsWith("[]", n)) {
                    stringBuffer.append('[');
                    n += "[]".length();
                }
                String string = this._typeName.substring(n);
                if (string.equals("void")) {
                    stringBuffer.append('V');
                } else if (string.equals("boolean")) {
                    stringBuffer.append('Z');
                } else if (string.equals("byte")) {
                    stringBuffer.append('B');
                } else if (string.equals("short")) {
                    stringBuffer.append('S');
                } else if (string.equals("long")) {
                    stringBuffer.append('I');
                } else if (string.equals("hyper")) {
                    stringBuffer.append('J');
                } else if (string.equals("float")) {
                    stringBuffer.append('F');
                } else if (string.equals("double")) {
                    stringBuffer.append('D');
                } else if (string.equals("char")) {
                    stringBuffer.append('C');
                } else if (string.equals("string")) {
                    stringBuffer.append("Ljava.lang.String;");
                } else if (string.equals("type")) {
                    stringBuffer.append("Lcom.sun.star.uno.Type;");
                } else if (string.equals("any")) {
                    stringBuffer.append("Ljava.lang.Object;");
                } else {
                    if (string.equals("unsigned short") || string.equals("unsigned long") || string.equals("unsigned hyper")) {
                        return null;
                    }
                    stringBuffer.append('L');
                    stringBuffer.append(string);
                    stringBuffer.append(';');
                }
                try {
                    return Class.forName(stringBuffer.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
            case 15: 
            case 17: 
            case 19: 
            case 22: {
                try {
                    return Class.forName(this._typeName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        }
        return null;
    }

    public ITypeDescription getTypeDescription() {
        return this._iTypeDescription;
    }

    public void setTypeDescription(ITypeDescription iTypeDescription) {
        this._iTypeDescription = iTypeDescription;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof Type && this._typeName.equals(((Type)object)._typeName);
    }

    public int hashCode() {
        return this._typeName.hashCode();
    }

    public String toString() {
        return "Type[" + this._typeName + "]";
    }

    private static boolean __isTypeClassPrimitive(TypeClass typeClass) {
        return typeClass.getValue() < __typeClassToTypeName.length;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        int n = 0;
        while (n < __typeClassToTypeName.length) {
            __typeNameToTypeClass.put(__typeClassToTypeName[n], TypeClass.fromInt(n));
            ++n;
        }
        __javaClassToTypeName.put(class$java$lang$Void == null ? (class$java$lang$Void = Type.class$("java.lang.Void")) : class$java$lang$Void, "void");
        __javaClassToTypeName.put(Void.TYPE, "void");
        __javaClassToTypeName.put(class$java$lang$Character == null ? (class$java$lang$Character = Type.class$("java.lang.Character")) : class$java$lang$Character, "char");
        __javaClassToTypeName.put(Character.TYPE, "char");
        __javaClassToTypeName.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Type.class$("java.lang.Boolean")) : class$java$lang$Boolean, "boolean");
        __javaClassToTypeName.put(Boolean.TYPE, "boolean");
        __javaClassToTypeName.put(class$java$lang$Byte == null ? (class$java$lang$Byte = Type.class$("java.lang.Byte")) : class$java$lang$Byte, "byte");
        __javaClassToTypeName.put(Byte.TYPE, "byte");
        __javaClassToTypeName.put(class$java$lang$Short == null ? (class$java$lang$Short = Type.class$("java.lang.Short")) : class$java$lang$Short, "short");
        __javaClassToTypeName.put(Short.TYPE, "short");
        __javaClassToTypeName.put(class$java$lang$Integer == null ? (class$java$lang$Integer = Type.class$("java.lang.Integer")) : class$java$lang$Integer, "long");
        __javaClassToTypeName.put(Integer.TYPE, "long");
        __javaClassToTypeName.put(class$java$lang$Long == null ? (class$java$lang$Long = Type.class$("java.lang.Long")) : class$java$lang$Long, "hyper");
        __javaClassToTypeName.put(Long.TYPE, "hyper");
        __javaClassToTypeName.put(class$java$lang$Float == null ? (class$java$lang$Float = Type.class$("java.lang.Float")) : class$java$lang$Float, "float");
        __javaClassToTypeName.put(Float.TYPE, "float");
        __javaClassToTypeName.put(class$java$lang$Double == null ? (class$java$lang$Double = Type.class$("java.lang.Double")) : class$java$lang$Double, "double");
        __javaClassToTypeName.put(Double.TYPE, "double");
        __javaClassToTypeName.put(class$java$lang$String == null ? (class$java$lang$String = Type.class$("java.lang.String")) : class$java$lang$String, "string");
        __javaClassToTypeName.put(class$com$sun$star$uno$Type == null ? (class$com$sun$star$uno$Type = Type.class$("com.sun.star.uno.Type")) : class$com$sun$star$uno$Type, "type");
        __javaClassToTypeName.put(class$com$sun$star$uno$Any == null ? (class$com$sun$star$uno$Any = Type.class$("com.sun.star.uno.Any")) : class$com$sun$star$uno$Any, "any");
        __javaClassToTypeName.put(class$java$lang$Object == null ? (class$java$lang$Object = Type.class$("java.lang.Object")) : class$java$lang$Object, "any");
        VOID = new Type(Void.TYPE);
        CHAR = new Type(Character.TYPE);
        BOOLEAN = new Type(Boolean.TYPE);
        BYTE = new Type(Byte.TYPE);
        SHORT = new Type(Short.TYPE);
        UNSIGNED_SHORT = new Type("unsigned short", TypeClass.UNSIGNED_SHORT);
        LONG = new Type(Integer.TYPE);
        UNSIGNED_LONG = new Type("unsigned long", TypeClass.UNSIGNED_LONG);
        HYPER = new Type(Long.TYPE);
        UNSIGNED_HYPER = new Type("unsigned hyper", TypeClass.UNSIGNED_HYPER);
        FLOAT = new Type(Float.TYPE);
        DOUBLE = new Type(Double.TYPE);
        STRING = new Type(class$java$lang$String == null ? (class$java$lang$String = Type.class$("java.lang.String")) : class$java$lang$String);
        TYPE = new Type(class$com$sun$star$uno$Type == null ? (class$com$sun$star$uno$Type = Type.class$("com.sun.star.uno.Type")) : class$com$sun$star$uno$Type);
        ANY = new Type(class$com$sun$star$uno$Any == null ? (class$com$sun$star$uno$Any = Type.class$("com.sun.star.uno.Any")) : class$com$sun$star$uno$Any);
    }
}

