/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.AccessibleRelation;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleRelationSet;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleEditableTextImpl;
import org.openoffice.java.accessibility.AccessibleHypertextImpl;
import org.openoffice.java.accessibility.Component;
import org.openoffice.java.accessibility.Container;

public class Paragraph
extends Container
implements Accessible {
    boolean multiLine = false;
    boolean editable = false;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleEditableText;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleAction;

    protected Paragraph(XAccessible xAccessible, XAccessibleContext xAccessibleContext, XAccessibleStateSet xAccessibleStateSet) {
        super(AccessibleRole.TEXT, xAccessible, xAccessibleContext);
        this.editable = xAccessibleStateSet.contains((short)6);
        this.multiLine = xAccessibleStateSet.contains((short)17);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleParagraphListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleParagraph();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleParagraph
    extends Container.AccessibleContainer {
        protected AccessibleParagraph() {
            super(false);
            Paragraph.this.accessibleText = AccessibleHypertextImpl.get((XInterface)Paragraph.this.unoAccessibleContext);
        }

        protected AccessibleStateSet getAccessibleStateSetImpl(XAccessibleStateSet xAccessibleStateSet) {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSetImpl(xAccessibleStateSet);
            if (Paragraph.this.editable) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            if (Paragraph.this.multiLine) {
                accessibleStateSet.add(AccessibleState.MULTI_LINE);
            } else {
                accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleEditableText getAccessibleEditableText() {
            try {
                XAccessibleEditableText xAccessibleEditableText = (XAccessibleEditableText)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleEditableText == null ? (class$com$sun$star$accessibility$XAccessibleEditableText = Paragraph.class$("com.sun.star.accessibility.XAccessibleEditableText")) : class$com$sun$star$accessibility$XAccessibleEditableText), (Object)Paragraph.this.unoAccessibleComponent);
                if (xAccessibleEditableText != null) {
                    return new AccessibleEditableTextImpl(xAccessibleEditableText);
                }
                return null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public AccessibleAction getAccessibleAction() {
            try {
                XAccessibleAction xAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleAction == null ? (class$com$sun$star$accessibility$XAccessibleAction = Paragraph.class$("com.sun.star.accessibility.XAccessibleAction")) : class$com$sun$star$accessibility$XAccessibleAction), (Object)Paragraph.this.unoAccessibleComponent);
                return xAccessibleAction != null ? new AccessibleActionImpl(xAccessibleAction) : null;
            }
            catch (RuntimeException runtimeException) {
                return null;
            }
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            try {
                XAccessibleRelationSet xAccessibleRelationSet = Paragraph.this.unoAccessible.getAccessibleContext().getAccessibleRelationSet();
                if (xAccessibleRelationSet == null) {
                    return super.getAccessibleRelationSet();
                }
                AccessibleRelationSet accessibleRelationSet = new AccessibleRelationSet();
                int n = xAccessibleRelationSet.getRelationCount();
                int n2 = 0;
                while (n2 < n) {
                    AccessibleRelation accessibleRelation = xAccessibleRelationSet.getRelation(n2);
                    switch (accessibleRelation.RelationType) {
                        case 3: {
                            accessibleRelationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.CONTROLLED_BY, Paragraph.this.getAccessibleComponents(accessibleRelation.TargetSet)));
                            break;
                        }
                        case 4: {
                            accessibleRelationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.CONTROLLER_FOR, Paragraph.this.getAccessibleComponents(accessibleRelation.TargetSet)));
                            break;
                        }
                        case 6: {
                            accessibleRelationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.LABELED_BY, Paragraph.this.getAccessibleComponents(accessibleRelation.TargetSet)));
                            break;
                        }
                        case 7: {
                            accessibleRelationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.MEMBER_OF, Paragraph.this.getAccessibleComponents(accessibleRelation.TargetSet)));
                            break;
                        }
                    }
                    ++n2;
                }
                return accessibleRelationSet;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return super.getAccessibleRelationSet();
            }
            catch (RuntimeException runtimeException) {
                return super.getAccessibleRelationSet();
            }
        }
    }

    protected class AccessibleParagraphListener
    extends Container.AccessibleContainerListener {
        protected AccessibleParagraphListener() {
        }

        protected void setComponentState(short s, boolean bl) {
            switch (s) {
                case 6: {
                    Paragraph.this.editable = bl;
                    Paragraph.this.fireStatePropertyChange(AccessibleState.EDITABLE, bl);
                    break;
                }
                case 17: {
                    Paragraph.this.multiLine = bl;
                    Paragraph.this.fireStatePropertyChange(AccessibleState.MULTI_LINE, bl);
                    break;
                }
                case 26: {
                    break;
                }
                default: {
                    super.setComponentState(s, bl);
                }
            }
        }

        protected void handleVisibleDataChanged() {
            AccessibleText accessibleText;
            AccessibleContext accessibleContext;
            if (Paragraph.this.isFocusOwner() && (accessibleContext = Paragraph.this.accessibleContext) != null && (accessibleText = accessibleContext.getAccessibleText()) != null) {
                int n = accessibleText.getCaretPosition();
                Paragraph.this.firePropertyChange("AccessibleCaret", new Integer(-1), new Integer(n));
            }
        }

        public void notifyEvent(AccessibleEventObject accessibleEventObject) {
            switch (accessibleEventObject.EventId) {
                case 20: {
                    AccessibleContext cfr_ignored_0 = Paragraph.this.accessibleContext;
                    Paragraph.this.firePropertyChange("AccessibleCaret", Component.toNumber(accessibleEventObject.OldValue), Component.toNumber(accessibleEventObject.NewValue));
                    break;
                }
                case 6: 
                case 10: {
                    this.handleVisibleDataChanged();
                }
                default: {
                    super.notifyEvent(accessibleEventObject);
                }
            }
        }
    }
}

