/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.filesystem;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarCreator;
import org.openide.TopManager;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class WriteableJarFileSystem
extends MultiFileSystem
implements PropertyChangeListener,
FileSystem.Status,
FileSystem.AtomicAction {
    static final long serialVersionUID = -7096247660760549348L;
    private FileSystem cacheFileSystem;
    private JarFileSystem jarFileSystem;
    private static final MessageFormat[] MESSAGES = new MessageFormat[2];
    private File cacheDir;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$filesystem$UpdateWritableJarFileSystemAction;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$filesystem$WriteableJarFileSystem;

    public WriteableJarFileSystem() {
        super(new FileSystem[1]);
        this.addPropertyChangeListener(this);
    }

    public FileSystem getCacheFileSystem() {
        return this.cacheFileSystem;
    }

    public void setCacheFileSystem(FileSystem fileSystem) {
        FileSystem fileSystem2;
        WriteableJarFileSystem writeableJarFileSystem = this;
        synchronized (writeableJarFileSystem) {
            fileSystem2 = this.cacheFileSystem;
            this.cacheFileSystem = fileSystem;
            if (fileSystem != null) {
                fileSystem.addPropertyChangeListener((PropertyChangeListener)this);
            }
            if (fileSystem2 != null) {
                fileSystem2.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
        this.firePropertyChange("cacheFileSystem", fileSystem2, fileSystem);
    }

    public File getJarFile() {
        JarFileSystem jarFileSystem = this.jarFileSystem;
        return jarFileSystem == null ? null : jarFileSystem.getJarFile();
    }

    public void setJarFile(File file) throws PropertyVetoException, IOException {
        File file2 = this.getJarFile();
        WriteableJarFileSystem writeableJarFileSystem = this;
        synchronized (writeableJarFileSystem) {
            JarFileSystem jarFileSystem = this.jarFileSystem;
            if (jarFileSystem == null) {
                jarFileSystem = new JarFileSystem();
            }
            jarFileSystem.setJarFile(file);
            this.jarFileSystem = jarFileSystem;
            if (this.cacheFileSystem == null) {
                FileSystem fileSystem = this.createTempFileSystem();
                fileSystem.addPropertyChangeListener((PropertyChangeListener)this);
                this.cacheFileSystem = fileSystem;
            }
        }
        this.firePropertyChange("jarFile", file2, file);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("cacheFileSystem".equals(propertyChangeEvent.getPropertyName()) || "jarFile".equals(propertyChangeEvent.getPropertyName())) {
            FileSystem[] fileSystemArray = null;
            fileSystemArray = this.cacheFileSystem != null && this.jarFileSystem != null ? new FileSystem[]{this.cacheFileSystem, this.jarFileSystem} : (this.cacheFileSystem != null ? new FileSystem[]{this.cacheFileSystem} : new FileSystem[]{new LocalFileSystem(), this.jarFileSystem});
            if (fileSystemArray != null) {
                this.setDelegates(fileSystemArray);
            }
        }
        this.getRoot().refresh(true);
        if (!"systemName".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() != this) {
            this.resetSystemName();
        }
    }

    private void resetSystemName() {
        try {
            if (this.cacheFileSystem == null || this.jarFileSystem == null) {
                this.setSystemName("");
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.cacheFileSystem.getSystemName());
            stringBuffer.append(this.jarFileSystem.getSystemName());
            this.setSystemName(stringBuffer.toString());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        MessageFormat messageFormat = new MessageFormat(WriteableJarFileSystem.getString0("FMT_DisplayName"));
        Object[] objectArray = new Object[]{this.jarFileSystem != null ? this.jarFileSystem.getDisplayName() : WriteableJarFileSystem.getString0("LAB_Error"), this.cacheFileSystem != null ? this.cacheFileSystem.getSystemName() : WriteableJarFileSystem.getString0("LAB_Error")};
        return messageFormat.format(objectArray);
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public String annotateName(String string, Set set) {
        Iterator iterator = set.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            if (fileObject.isRoot() || this.findSystem(fileObject) != this.cacheFileSystem) continue;
            n = 0;
            break;
        }
        return this.getMessage(n).format(new Object[]{string});
    }

    public Image annotateIcon(Image image, int n, Set set) {
        return image;
    }

    protected void notifyMigration(FileObject fileObject) {
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, fileObject, false, true));
    }

    private MessageFormat getMessage(int n) {
        if (MESSAGES[n] == null) {
            WriteableJarFileSystem.MESSAGES[n] = new MessageFormat(WriteableJarFileSystem.getString0("MSG_FS_" + n));
        }
        return MESSAGES[n];
    }

    private boolean jarContentNeedsUpdate() {
        FileSystem fileSystem = this.getCacheFileSystem();
        if (fileSystem == null) {
            return false;
        }
        Enumeration enumeration = fileSystem.getRoot().getChildren(true);
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            if (this.jarFileSystem == null) {
                return true;
            }
            FileObject fileObject2 = this.jarFileSystem.findResource(fileObject.getPackageNameExt('/', '.'));
            if (fileObject2 == null) {
                return true;
            }
            if (!fileObject.lastModified().after(fileObject2.lastModified())) continue;
            return true;
        }
        return false;
    }

    private File createNewJar() throws IOException {
        File file = this.jarFileSystem.getJarFile();
        File file2 = File.createTempFile("tmpJarFile" + Math.random(), "jar");
        file2.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        JarContent jarContent = new JarContent(JarContent.ALL);
        jarContent.addDataObject(DataObject.find((FileObject)this.getRoot()));
        JarCreator jarCreator = new JarCreator(jarContent);
        jarCreator.createJar(fileOutputStream, file2);
        return file2;
    }

    private void swapToNewJarFile(File file) throws IOException {
        try {
            JarFileSystem jarFileSystem = this.jarFileSystem;
            if (jarFileSystem == null) {
                return;
            }
            File file2 = jarFileSystem.getJarFile();
            jarFileSystem.removeNotify();
            if (file2 != null && !file2.delete()) {
                throw new IOException("Cannot delete old jar file");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            FileUtil.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
            jarFileSystem.setJarFile(file2);
            fileInputStream.close();
            fileOutputStream.close();
            file.delete();
            jarFileSystem.addNotify();
            this.getRoot().refresh(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            TopManager.getDefault().notifyException((Throwable)propertyVetoException);
        }
    }

    private FileSystem createTempFileSystem() {
        File file;
        String string = "WJFS" + String.valueOf(this.hashCode());
        try {
            file = File.createTempFile(string, null);
            file.delete();
            file.mkdirs();
        }
        catch (IOException iOException) {
            file = null;
        }
        LocalFileSystem localFileSystem = new LocalFileSystem();
        try {
            if (file != null) {
                localFileSystem.setRootDirectory(file);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            TopManager.getDefault().getErrorManager().notify((Throwable)propertyVetoException);
        }
        catch (IOException iOException) {
            TopManager.getDefault().getErrorManager().notify((Throwable)iOException);
        }
        return localFileSystem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearBaseFileSystem() {
        FileSystem fileSystem = this.getCacheFileSystem();
        if (fileSystem == null) {
            return;
        }
        JarFileSystem jarFileSystem = this.jarFileSystem;
        if (jarFileSystem == null) {
            return;
        }
        Enumeration enumeration = fileSystem.getRoot().getChildren(true);
        while (enumeration.hasMoreElements()) {
            Object var10_9;
            boolean bl;
            FileObject fileObject = (FileObject)enumeration.nextElement();
            FileObject fileObject2 = jarFileSystem.findResource(fileObject.getPackageNameExt('/', '.'));
            if (fileObject2 == null || !(bl = fileObject.lastModified().before(fileObject2.lastModified()))) continue;
            FileLock fileLock = null;
            try {
                try {
                    fileLock = fileObject.lock();
                    fileObject.delete(fileLock);
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException((Throwable)iOException);
                    var10_9 = null;
                    fileLock.releaseLock();
                    continue;
                }
                var10_9 = null;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                fileLock.releaseLock();
                throw throwable;
            }
            fileLock.releaseLock();
        }
        return;
    }

    public void updateJarFileContent() {
        try {
            this.runAtomicAction(this);
        }
        catch (IOException iOException) {
            TopManager.getDefault().notifyException((Throwable)iOException);
        }
    }

    public void run() throws IOException {
        if (this.jarContentNeedsUpdate()) {
            File file = this.createNewJar();
            this.swapToNewJarFile(file);
            this.clearBaseFileSystem();
            this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, true, true));
        }
    }

    public void prepareEnvironment(FileSystem.Environment environment) throws EnvironmentNotSupportedException {
        this.cacheFileSystem.prepareEnvironment(environment);
        if (this.jarFileSystem != null) {
            this.jarFileSystem.prepareEnvironment(environment);
        }
    }

    public SystemAction[] getActions(Set set) {
        SystemAction[] systemActionArray = super.getActions(set);
        SystemAction[] systemActionArray2 = new SystemAction[systemActionArray.length + 1];
        systemActionArray2[0] = SystemAction.get((Class)(class$org$netbeans$modules$jarpackager$filesystem$UpdateWritableJarFileSystemAction == null ? (class$org$netbeans$modules$jarpackager$filesystem$UpdateWritableJarFileSystemAction = WriteableJarFileSystem.class$("org.netbeans.modules.jarpackager.filesystem.UpdateWritableJarFileSystemAction")) : class$org$netbeans$modules$jarpackager$filesystem$UpdateWritableJarFileSystemAction));
        System.arraycopy(systemActionArray, 0, systemActionArray2, 1, systemActionArray.length);
        return systemActionArray2;
    }

    private static final String getString0(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$filesystem$WriteableJarFileSystem == null ? (class$org$netbeans$modules$jarpackager$filesystem$WriteableJarFileSystem = WriteableJarFileSystem.class$("org.netbeans.modules.jarpackager.filesystem.WriteableJarFileSystem")) : class$org$netbeans$modules$jarpackager$filesystem$WriteableJarFileSystem)).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

