/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.pipe;

import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnectionBroadcaster;
import com.sun.star.io.XStreamListener;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.RuntimeException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PipeConnection
implements XConnection,
XConnectionBroadcaster {
    public static final boolean DEBUG = false;
    protected String _aDescription;
    protected long _nPipeHandle;
    protected Vector _aListeners = new Vector();
    protected boolean _bFirstRead = true;
    static /* synthetic */ Class class$com$sun$star$lib$connections$pipe$PipeConnection;

    public PipeConnection(String string) throws IOException {
        String string2;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!string4.equals("pipe")) {
                throw new java.lang.RuntimeException("invalid pipe descriptor: does not start with 'pipe,'");
            }
            string2 = stringTokenizer.nextToken();
            if (!string2.substring(0, 5).equals("name=")) {
                throw new java.lang.RuntimeException("invalid pipe descriptor: no 'name=' parameter found");
            }
        } else {
            throw new java.lang.RuntimeException("invalid or empty pipe descriptor");
        }
        string3 = string2.substring(5);
        try {
            this.createJNI(string3);
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(nullPointerException.getMessage());
        }
        catch (com.sun.star.io.IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void addStreamListener(XStreamListener xStreamListener) throws RuntimeException {
        this._aListeners.addElement(xStreamListener);
    }

    public void removeStreamListener(XStreamListener xStreamListener) throws RuntimeException {
        this._aListeners.removeElement(xStreamListener);
    }

    private void notifyListeners_open() {
        Enumeration enumeration = this._aListeners.elements();
        while (enumeration.hasMoreElements()) {
            XStreamListener xStreamListener = (XStreamListener)enumeration.nextElement();
            xStreamListener.started();
        }
    }

    private void notifyListeners_close() {
        Enumeration enumeration = this._aListeners.elements();
        while (enumeration.hasMoreElements()) {
            XStreamListener xStreamListener = (XStreamListener)enumeration.nextElement();
            xStreamListener.closed();
        }
    }

    private void notifyListeners_error(com.sun.star.uno.Exception exception) {
        Enumeration enumeration = this._aListeners.elements();
        while (enumeration.hasMoreElements()) {
            XStreamListener xStreamListener = (XStreamListener)enumeration.nextElement();
            xStreamListener.error((Object)exception);
        }
    }

    private native int createJNI(String var1) throws com.sun.star.io.IOException, RuntimeException;

    private native int readJNI(byte[][] var1, int var2) throws com.sun.star.io.IOException, RuntimeException;

    private native void writeJNI(byte[] var1) throws com.sun.star.io.IOException, RuntimeException;

    private native void flushJNI() throws com.sun.star.io.IOException, RuntimeException;

    private native void closeJNI() throws com.sun.star.io.IOException, RuntimeException;

    public int read(byte[][] byArray, int n) throws com.sun.star.io.IOException, RuntimeException {
        if (this._bFirstRead) {
            this._bFirstRead = false;
            this.notifyListeners_open();
        }
        return this.readJNI(byArray, n);
    }

    public void write(byte[] byArray) throws com.sun.star.io.IOException, RuntimeException {
        this.writeJNI(byArray);
    }

    public void flush() throws com.sun.star.io.IOException, RuntimeException {
        this.flushJNI();
    }

    public void close() throws com.sun.star.io.IOException, RuntimeException {
        this.closeJNI();
        this.notifyListeners_close();
    }

    public String getDescription() throws RuntimeException {
        return this._aDescription;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        NativeLibraryLoader.loadLibrary((class$com$sun$star$lib$connections$pipe$PipeConnection == null ? (class$com$sun$star$lib$connections$pipe$PipeConnection = PipeConnection.class$("com.sun.star.lib.connections.pipe.PipeConnection")) : class$com$sun$star$lib$connections$pipe$PipeConnection).getClassLoader(), "jpipe");
    }
}

