/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.ThreadId;

class NativeThreadPool
implements IThreadPool {
    private static final boolean DEBUG = false;
    long _handle = NativeThreadPool.ncreate();
    Throwable _throwable;

    static native byte[] ngetThreadId();

    static native long ncreate();

    static native void nattach(long var0);

    static native void ndetach(long var0);

    static native Object nenter(long var0, boolean[] var2);

    static native void nputJob(long var0, byte[] var2, Job var3, boolean var4);

    static native void ndispose(long var0);

    static native void ndestroy(long var0);

    NativeThreadPool() {
    }

    public Object attach(ThreadId threadId) {
        this.attach();
        return null;
    }

    public void attach() {
        NativeThreadPool.nattach(this._handle);
    }

    public void detach() {
        NativeThreadPool.ndetach(this._handle);
    }

    public void detach(Object object, ThreadId threadId) {
        this.detach();
    }

    public Object enter(Object object, ThreadId threadId) throws Throwable {
        return this.enter();
    }

    public Object enter() throws Throwable {
        boolean[] blArray = new boolean[1];
        Object object = NativeThreadPool.nenter(this._handle, blArray);
        if (blArray[0]) {
            throw this._throwable;
        }
        return object;
    }

    public void putJob(Job job) {
        NativeThreadPool.nputJob(this._handle, job.getThreadId().getBytes(), job, !job.isSynchron());
    }

    public void dispose(Throwable throwable) {
        this._throwable = throwable;
        NativeThreadPool.ndispose(this._handle);
    }

    public void destroy() {
        NativeThreadPool.ndetach(this._handle);
    }

    static {
        try {
            System.loadLibrary("java_uno");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("NativeThreadPool.<sinit> - unexpected: " + unsatisfiedLinkError);
            throw unsatisfiedLinkError;
        }
    }
}

