package com.sun.star.beans;

final public class PropertyState extends com.sun.star.uno.Enum
{
    private PropertyState(int value)
    {
        super(value);
    }

    public static PropertyState getDefault()
    {
        return DIRECT_VALUE;
    }

    public static final PropertyState DIRECT_VALUE = new PropertyState(0);
    public static final int DIRECT_VALUE_value = 0;
    public static final PropertyState DEFAULT_VALUE = new PropertyState(1);
    public static final int DEFAULT_VALUE_value = 1;
    public static final PropertyState AMBIGUOUS_VALUE = new PropertyState(2);
    public static final int AMBIGUOUS_VALUE_value = 2;

    public static PropertyState fromInt(int value)
    {
        switch( value )
        {
            case 0:
                return DIRECT_VALUE;
            case 1:
                return DEFAULT_VALUE;
            case 2:
                return AMBIGUOUS_VALUE;
            default:
                return null;
        }
    }
}
