package com.sun.star.reflection;

final public class FieldAccessMode extends com.sun.star.uno.Enum
{
    private FieldAccessMode(int value)
    {
        super(value);
    }

    public static FieldAccessMode getDefault()
    {
        return READWRITE;
    }

    public static final FieldAccessMode READWRITE = new FieldAccessMode(0);
    public static final int READWRITE_value = 0;
    public static final FieldAccessMode READONLY = new FieldAccessMode(1);
    public static final int READONLY_value = 1;
    public static final FieldAccessMode WRITEONLY = new FieldAccessMode(2);
    public static final int WRITEONLY_value = 2;
    public static final FieldAccessMode CONST = new FieldAccessMode(3);
    public static final int CONST_value = 3;

    public static FieldAccessMode fromInt(int value)
    {
        switch( value )
        {
            case 0:
                return READWRITE;
            case 1:
                return READONLY;
            case 2:
                return WRITEONLY;
            case 3:
                return CONST;
            default:
                return null;
        }
    }
}
