package com.sun.star.registry;

final public class RegistryValueType extends com.sun.star.uno.Enum
{
    private RegistryValueType(int value)
    {
        super(value);
    }

    public static RegistryValueType getDefault()
    {
        return NOT_DEFINED;
    }

    public static final RegistryValueType NOT_DEFINED = new RegistryValueType(0);
    public static final int NOT_DEFINED_value = 0;
    public static final RegistryValueType LONG = new RegistryValueType(1);
    public static final int LONG_value = 1;
    public static final RegistryValueType ASCII = new RegistryValueType(2);
    public static final int ASCII_value = 2;
    public static final RegistryValueType STRING = new RegistryValueType(3);
    public static final int STRING_value = 3;
    public static final RegistryValueType BINARY = new RegistryValueType(4);
    public static final int BINARY_value = 4;
    public static final RegistryValueType LONGLIST = new RegistryValueType(5);
    public static final int LONGLIST_value = 5;
    public static final RegistryValueType ASCIILIST = new RegistryValueType(6);
    public static final int ASCIILIST_value = 6;
    public static final RegistryValueType STRINGLIST = new RegistryValueType(7);
    public static final int STRINGLIST_value = 7;

    public static RegistryValueType fromInt(int value)
    {
        switch( value )
        {
            case 0:
                return NOT_DEFINED;
            case 1:
                return LONG;
            case 2:
                return ASCII;
            case 3:
                return STRING;
            case 4:
                return BINARY;
            case 5:
                return LONGLIST;
            case 6:
                return ASCIILIST;
            case 7:
                return STRINGLIST;
            default:
                return null;
        }
    }
}
