/*************************************************************************
 *
 *  $RCSfile: fontsubs.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: os $ $Date: 2002/08/30 09:59:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_FONT_SUBSTITUTION_HXX
#define _SVX_FONT_SUBSTITUTION_HXX

#ifndef _SFXTABDLG_HXX //autogen
#include <sfx2/tabdlg.hxx>
#endif
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _SVX_SIMPTABL_HXX //autogen
#include <svx/simptabl.hxx>
#endif
#ifndef _SV_TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _CTRLBOX_HXX //autogen
#include <svtools/ctrlbox.hxx>
#endif

// class SvxFontSubstCheckListBox ------------------------------------------

class SvxFontSubstCheckListBox : public SvxSimpleTable
{
	friend class SvxFontSubstTabPage;

	protected:
		virtual void	SetTabs();
        virtual void    KeyInput( const KeyEvent& rKEvt );

	public:
		SvxFontSubstCheckListBox(Window* pParent, const ResId& rResId ) :
			SvxSimpleTable( pParent, rResId ){}

		inline void 	*GetUserData(ULONG nPos) { return GetEntry(nPos)->GetUserData(); }
		inline void		SetUserData(ULONG nPos, void *pData ) { GetEntry(nPos)->SetUserData(pData); }

		BOOL			IsChecked(ULONG nPos, USHORT nCol = 0);
		BOOL			IsChecked(SvLBoxEntry* pEntry, USHORT nCol = 0);
		void			CheckEntryPos(ULONG nPos, USHORT nCol, BOOL bChecked);
		void			CheckEntry(SvLBoxEntry* pEntry, USHORT nCol, BOOL bChecked);
		SvButtonState	GetCheckButtonState( SvLBoxEntry*, USHORT nCol ) const;
		void			SetCheckButtonState( SvLBoxEntry*, USHORT nCol, SvButtonState );
};

// class SvxFontSubstTabPage ----------------------------------------------------
class OfaFontSubstConfig;
namespace svt {class SourceViewConfig;}
class SvxFontSubstTabPage : public SfxTabPage
{
	CheckBox					aUseTableCB;
    FixedText                   aFont1FT;
	FontNameBox					aFont1CB;
	FixedText					aFont2FT;
	FontNameBox					aFont2CB;
	ToolBox						aNewDelTBX;
    SvxFontSubstCheckListBox    aCheckLB;

    FixedLine                   aSourceViewFontsFL;
    FixedText                   aFontNameFT;
    ListBox                     aFontNameLB;
    CheckBox                    aNonPropFontsOnlyCB;
    FixedText                   aFontHeightFT;
    ListBox                     aFontHeightLB;

    ImageList                   aImageList;
    String                      sAutomatic;

	OfaFontSubstConfig*			pConfig;
    svt::SourceViewConfig*      pSourceViewConfig;

	String			sHeader1;
	String			sHeader2;
	String			sHeader3;
	String			sHeader4;

	Bitmap			aChkunBmp;
	Bitmap			aChkchBmp;
	Bitmap			aChkchhiBmp;
	Bitmap			aChkunhiBmp;
	Bitmap			aChktriBmp;
	Bitmap			aChktrihiBmp;
	Color			aTextColor;
	ByteString		sFontGroup;

	SvLBoxButtonData*	pCheckButtonData;

	DECL_LINK(SelectHdl, Window *pWin = 0);
    DECL_LINK(NonPropFontsHdl, CheckBox* pBox);

	SvLBoxEntry*	CreateEntry(String& rFont1, String& rFont2);
	void			CheckEnable();

	SvxFontSubstTabPage( Window* pParent, const SfxItemSet& rSet );
	~SvxFontSubstTabPage();

public:
	static SfxTabPage*  Create( Window* pParent, const SfxItemSet& rAttrSet);
	virtual BOOL        FillItemSet( SfxItemSet& rSet );
	virtual void        Reset( const SfxItemSet& rSet );
};

#endif // _SVX_FONT_SUBSTITUTION_HXX

