/*************************************************************************
 *
 *  $RCSfile: lexem.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dv $ $Date: 2001/10/05 08:16:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SETUP_LEXEM_HXX
#define SETUP_LEXEM_HXX

#include <setup2/ident.hxx>

enum SiLexemType
{
	LT_NULL,
	LT_ERR,
	LT_EOF,

	LT_ICONST,      // integer constant
	LT_SCONST,      // string constant
	LT_ID,          // identifier

	LT_COMMA,
	LT_SEMICOLON,
	LT_ASSIGN,

	LT_POPEN,       // '('  p = parenthesis
	LT_PCLOSE,      // ')'

	LT_MODULE,      // Schsselworte
	LT_MODULELIST,
	LT_MODULESET,
	LT_DIRECTORY,
	LT_FILE,
	LT_DATACARRIER,
	LT_FOLDER,
	LT_FOLDERITEM,
	LT_PROFILE,
	LT_PROFILEITEM,
	LT_PROCEDURE,
	LT_CUSTOM,
	LT_SLIDE,
	LT_REGISTRYITEM,
	LT_REGISTRYAREA,
	LT_END,
	LT_OS2_CREATOR,
	LT_OS2_TEMPLATE,
	LT_OS2_CLASS,
	LT_SHORTCUT,
	LT_INSTALLATION,
	LT_HELPTEXT,
	LT_SCPACTION,
	LT_STARREGISTRY,
	LT_STARREGISTRY_ITEM,
	LT_CONFIGURATION_ITEM
};

enum SiLexemError
{
	LE_NULL,          // kein Fehler
	LE_NOTPRINTABLE,  // nicht druckbares Zeichen in ByteStringkonstante
	LE_NOTBEGIN       // Zeichen ist nicht der Anfang eines Lexems
};

class SiLexem
{
	SiLexemType		m_LexemType;
	SiLexemError	m_LexemError;
	ByteString		m_Value;

	void Construct( SiLexemType 		= LT_NULL,
					SiLexemError		= LE_NULL,
					ByteString const&	= ByteString("") );

public:
		SiLexem();
		SiLexem( SiLexemType eType);
		SiLexem( SiLexemType eType, ByteString const& s );
		SiLexem( SiLexemError eError, ByteString const& s );

	// Zugriff auf Member
	SiLexemType			GetType()			   const { return m_LexemType; }
	SiLexemError		GetError()			   const;
	sal_Int32			GetValueAsInt32()	   const;
	sal_uInt32			GetValueAsUInt32()	   const;
	ByteString const&	GetValueAsString()     const { return m_Value; }
	SiIdentifier		GetValueAsIdentifier() const { return m_Value; }
};

// inlines ----------------------------------------------------------

inline SiLexem::SiLexem()
{ Construct(); }

inline SiLexem::SiLexem(SiLexemType eType)
{ Construct(eType); }

inline SiLexem::SiLexem(SiLexemType eType, ByteString const& s)
{ Construct(eType, LE_NULL, s); }

inline SiLexem::SiLexem(SiLexemError eError, ByteString const& s)
{ Construct(LT_ERR, eError, s); }

#endif // _LEXEM_HXX
