/*************************************************************************
 *
 *	$RCSfile: inputctx.hxx,v $
 *
 *	$Revision: 1.2 $
 *
 *	last change: $Author: th $ $Date: 2000/11/06 22:28:04 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _VCL_INPUTCTX_HXX
#define _VCL_INPUTCTX_HXX

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _SV_FONT_HXX
#include <vcl/font.hxx>
#endif

// ----------------------
// - InputContext-Flags -
// ----------------------

#define INPUTCONTEXT_TEXT				((ULONG)0x00000001)
#define INPUTCONTEXT_EXTTEXTINPUT		((ULONG)0x00000002)
#define INPUTCONTEXT_EXTTEXTINPUT_ON	((ULONG)0x00000004)
#define INPUTCONTEXT_EXTTEXTINPUT_OFF	((ULONG)0x00000008)

// ----------------
// - InputContext -
// ----------------

class InputContext
{
private:
	Font			maFont;
	ULONG			mnOptions;

public:
					InputContext() { mnOptions = 0; }
					InputContext( const InputContext& rInputContext ) :
						maFont( rInputContext.maFont )
					{ mnOptions = rInputContext.mnOptions; }
					InputContext( const Font& rFont, ULONG nOptions = 0 ) :
						maFont( rFont )
					{ mnOptions = nOptions; }

	void			SetFont( const Font& rFont ) { maFont = rFont; }
	const Font& 	GetFont() const { return maFont; }

	void			SetOptions( ULONG nOptions ) { mnOptions = nOptions; }
	ULONG			GetOptions() const { return mnOptions; }

	InputContext&	operator=( const InputContext& rInputContext );
	BOOL			operator==( const InputContext& rInputContext ) const;
	BOOL			operator!=( const InputContext& rInputContext ) const
						{ return !(InputContext::operator==( rInputContext )); }
};

inline InputContext& InputContext::operator=( const InputContext& rInputContext )
{
	maFont		= rInputContext.maFont;
	mnOptions	= rInputContext.mnOptions;
	return *this;
}

inline BOOL InputContext::operator==( const InputContext& rInputContext ) const
{
	return ((mnOptions	== rInputContext.mnOptions) &&
			(maFont 	== rInputContext.maFont));
}

#endif // _VCL_INPUTCTX_HXX
