/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.helper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PrettyPrinter
extends HandlerBase {
    private static BufferedWriter out = null;
    private String indentString = "\t";
    private boolean bHasContentOrSubElements = true;
    private int indentLevel = 0;
    private static int NONE = 0;
    private static int START_ELEMENT = 1;
    private static int CONTENT = 2;
    private static int END_ELEMENT = 3;
    private int nStatus = NONE;

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: cmd filename outfile");
            System.exit(1);
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(stringArray[1]), "UTF8"));
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new File(stringArray[0]), (HandlerBase)new PrettyPrinter());
            if (out != null) {
                out.close();
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.exit(0);
    }

    private String transform(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.emit("<?xml version='1.0' encoding='UTF-8'?>");
        this.nl();
    }

    public void endDocument() throws SAXException {
        this.nl();
        try {
            this.nl();
            out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.indentLevel != 0 && this.nStatus == START_ELEMENT) {
            this.emit(">");
        }
        this.nStatus = START_ELEMENT;
        this.nl();
        this.emit("<" + string);
        if (attributeList != null) {
            for (int i = 0; i < attributeList.getLength(); ++i) {
                this.emit(" ");
                this.emit(attributeList.getName(i));
                this.emit("=");
                this.emit("\"");
                this.emit(this.transform(attributeList.getValue(i)));
                this.emit("\"");
            }
        }
        ++this.indentLevel;
    }

    public void endElement(String string) throws SAXException {
        --this.indentLevel;
        if (this.nStatus == START_ELEMENT) {
            this.emit("/>");
        } else {
            if (this.nStatus != CONTENT) {
                this.nl();
            }
            this.emit("</" + string + ">");
        }
        this.nStatus = END_ELEMENT;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.nStatus != CONTENT && string.trim().equals("") && (this.nStatus != START_ELEMENT || string.equals("\n") || string.equals("\r") || string.equals(System.getProperty("line.separator")))) {
            return;
        }
        if (this.nStatus == START_ELEMENT) {
            this.emit(">");
        }
        this.emit(this.transform(string));
        this.nStatus = CONTENT;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.nStatus == START_ELEMENT) {
            this.emit(">");
        }
        this.emit(this.transform(string));
        this.nStatus = CONTENT;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private void emit(String string) throws SAXException {
        try {
            out.write(string);
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    private void nl() throws SAXException {
        String string = System.getProperty("line.separator");
        try {
            out.write(string);
            for (int i = 0; i < this.indentLevel; ++i) {
                out.write(this.indentString);
            }
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }
}

