/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.help;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import com.sun.star.help.HelpURLParameter;
import com.sun.star.help.StringDbt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.jar.JarFile;

public final class HelpDatabases {
    private static String _installDirectory = System.getProperty("com.sun.star.help.Directory");
    private static final Hashtable _dbHash = new Hashtable();
    private static final Hashtable _jarHash = new Hashtable();
    public static final Hashtable _modInfo = new Hashtable();
    public static final HashSet langSet = new HashSet();
    static Hashtable _helptextHash = new Hashtable();
    private static final Hashtable _keyword = new Hashtable();

    public static synchronized void setInstallPath(String string) {
        _installDirectory = string;
    }

    public static String getURLMode() {
        return new String("with-files");
    }

    public static String[] getModuleList(String string) {
        String string2 = _installDirectory + HelpDatabases.lang(string);
        File file = new File(string2);
        if (file.isDirectory()) {
            return file.list(new DbFilter());
        }
        return null;
    }

    public static String getInstallDirectory() {
        return _installDirectory;
    }

    public static synchronized String lang(String string) {
        String string2 = string;
        if (!langSet.contains(string2)) {
            int n;
            if (!(new File(_installDirectory + string2).exists() || (n = string2.indexOf(45)) == -1 && (n = string2.indexOf(95)) == -1)) {
                string2 = string2.substring(0, n);
            }
            langSet.add(string2);
        }
        return string2;
    }

    public static synchronized StaticModuleInformation getStaticInformationForModule(String string, String string2) {
        String string3 = HelpDatabases.lang(string2) + File.separator + string;
        StaticModuleInformation staticModuleInformation = (StaticModuleInformation)_modInfo.get(string3);
        if (staticModuleInformation == null) {
            String string4 = _installDirectory + string3 + ".cfg";
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            try {
                InputStreamReader inputStreamReader;
                try {
                    inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    inputStreamReader = new InputStreamReader(fileInputStream);
                }
                String string5 = new String();
                char[] cArray = new char[128];
                while (inputStreamReader.read(cArray, 0, 128) != -1) {
                    string5 = string5 + new String(cArray);
                    cArray = new char[128];
                }
                inputStreamReader.close();
                fileInputStream.close();
                String string6 = new String();
                String string7 = null;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                String string11 = "";
                String string12 = "";
                for (int i = 0; i < string5.length(); ++i) {
                    char c = string5.charAt(i);
                    if (c == '\n' || c == '\r') {
                        if (string6.length() != 0) {
                            if (string6.startsWith("Title")) {
                                string10 = string6.substring(string6.indexOf(61) + 1);
                            } else if (string6.startsWith("Start")) {
                                string9 = string6.substring(string6.indexOf(61) + 1);
                            } else if (string6.startsWith("Language")) {
                                string7 = string6.substring(string6.indexOf(61) + 1);
                            } else if (string6.startsWith("Program")) {
                                string8 = string6.substring(string6.indexOf(61) + 1);
                            } else if (string6.startsWith("Heading")) {
                                string11 = string6.substring(string6.indexOf(61) + 1);
                            } else if (string6.startsWith("FullText")) {
                                string12 = string6.substring(string6.indexOf(61) + 1);
                            }
                        }
                        string6 = new String();
                        continue;
                    }
                    string6 = string6 + c;
                }
                staticModuleInformation = new StaticModuleInformation(string10, string9, string8, string11, string12);
                _modInfo.put(string3, staticModuleInformation);
            }
            catch (Exception exception) {
                System.err.println("Corrupted cfg-file: " + string4);
                exception.printStackTrace();
            }
        }
        return staticModuleInformation;
    }

    public static synchronized Db getDatabaseForLanguage(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = HelpDatabases.lang(string2) + File.separator + string;
        Db db = (Db)_dbHash.get(string3);
        if (db == null) {
            try {
                db = new Db(null, 0);
                String string4 = _installDirectory + string3 + ".db";
                db.open(null, string4, null, 1, Db.DB_RDONLY, 420);
                _dbHash.put(string3, db);
            }
            catch (DbException dbException) {
                System.err.println("Unsupported language in helpsystem: " + string2);
                System.err.println("module: " + string);
                System.err.println(dbException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Unsupported language in helpsystem: " + string2);
                System.err.println("module: " + string);
                System.err.println(fileNotFoundException.getMessage());
            }
        }
        return db;
    }

    public static synchronized Db getHelptextDbForLanguage(String string, String string2) {
        String string3 = HelpDatabases.lang(string2) + File.separator + string;
        Db db = (Db)_helptextHash.get(string3);
        if (db == null) {
            try {
                db = new Db(null, 0);
                String string4 = _installDirectory + string3 + ".ht";
                db.open(null, string4, null, 1, Db.DB_RDONLY, 420);
                _dbHash.put(string3, db);
            }
            catch (DbException dbException) {
                System.err.println("Unsupported language in helpsystem: " + string2);
                System.err.println("module: " + string);
                System.err.println(dbException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Unsupported language in helpsystem: " + string2);
                System.err.println("module: " + string);
                System.err.println(fileNotFoundException.getMessage());
            }
        }
        return db;
    }

    public static synchronized JarFile getJarFileForLanguage(String string, String string2) {
        if (string2 == null || string == null) {
            return null;
        }
        String string3 = HelpDatabases.lang(string2) + File.separator + string;
        JarFile jarFile = (JarFile)_jarHash.get(string3);
        if (jarFile == null) {
            try {
                File file = new File(_installDirectory + string3);
                if (!file.exists()) {
                    throw new IOException();
                }
                jarFile = new JarFile(file);
                _jarHash.put(string3, jarFile);
            }
            catch (IOException iOException) {
                System.err.println("Jarfile not found: " + string + " " + string2);
            }
        }
        return jarFile;
    }

    public static InputStream getCssSheet() {
        try {
            return new FileInputStream(_installDirectory + "custom.css");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static InputStream errorFile(String string) {
        try {
            return new FileInputStream(_installDirectory + HelpDatabases.lang(string) + File.separator + "err.html");
        }
        catch (IOException iOException) {
            String string2 = " <html><body>              The requested document does not exist in the database !!             </body></html> ";
            return new ByteArrayInputStream(string2.getBytes());
        }
    }

    public static InputStream popupDocument(HelpURLParameter helpURLParameter) {
        String string = " <html>                                                                                  <head>                                                                                  <help:css-file-link xmlns:help=\"http://openoffice.org/2000/help\"/>                    </head>                                                                                 <body>                                                                                  <help:popup-cut Id=\"" + helpURLParameter.get_id() + "\" Eid=\"" + helpURLParameter.get_eid() + "\" xmlns:help=\"http://openoffice.org/2000/help\"></help:popup-cut>  " + " </body>                                                                                " + " </html>                                                                                ";
        System.out.println(string);
        return new ByteArrayInputStream(string.getBytes());
    }

    public static synchronized KeywordInfo getKeyword(String string, String string2) {
        String string3 = HelpDatabases.lang(string2) + File.separator + string;
        KeywordInfo keywordInfo = (KeywordInfo)_keyword.get(string3);
        if (keywordInfo == null) {
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                String string4 = HelpDatabases.getInstallDirectory() + string3 + ".key";
                Db db = new Db(null, 0);
                System.err.println(string4);
                db.open(null, string4, null, 1, Db.DB_RDONLY, 420);
                Dbc dbc = db.cursor(null, 0);
                StringDbt stringDbt = new StringDbt();
                StringDbt stringDbt2 = new StringDbt();
                boolean bl = true;
                stringDbt.set_flags(Db.DB_DBT_MALLOC);
                stringDbt2.set_flags(Db.DB_DBT_MALLOC);
                keywordInfo = new KeywordInfo();
                while (-30990 != dbc.get((Dbt)stringDbt, (Dbt)stringDbt2, Db.DB_NEXT)) {
                    String string5 = stringDbt.getString();
                    keywordInfo.insert(string5);
                    hashMap.put(string5, stringDbt2.getString());
                    if (!bl) continue;
                    stringDbt.set_flags(Db.DB_DBT_REALLOC);
                    stringDbt2.set_flags(Db.DB_DBT_REALLOC);
                    bl = false;
                }
                keywordInfo.sort();
                dbc.close();
                db.close(0);
                String[] stringArray = keywordInfo.getKeywordList();
                Db db2 = HelpDatabases.getDatabaseForLanguage(string, string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = keywordInfo.insertId(i, (String)hashMap.get(stringArray[i]));
                    String[] stringArray3 = keywordInfo.getTitleForIndex(i);
                    for (int j = 0; j < stringArray2.length; ++j) {
                        StringDbt stringDbt3 = new StringDbt();
                        stringDbt3.setString(stringArray2[j]);
                        StringDbt stringDbt4 = new StringDbt();
                        try {
                            db2.get(null, (Dbt)stringDbt3, (Dbt)stringDbt4, 0);
                            stringArray3[j] = stringDbt4.getTitle();
                            continue;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            stringArray3[j] = "";
                        }
                    }
                }
                _keyword.put(string3, keywordInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("any other exception in getKeyword: " + exception.getMessage());
            }
        }
        return keywordInfo;
    }

    public static final class KeywordInfo {
        int pos = 0;
        String[] listKey = new String[100];
        String[][] listId;
        String[][] listAnchor;
        String[][] listTitle;

        public String[] getKeywordList() {
            return this.listKey;
        }

        public String[][] getIdList() {
            return this.listId;
        }

        public String[][] getAnchorList() {
            return this.listAnchor;
        }

        public String[][] getTitleList() {
            return this.listTitle;
        }

        private void realloc(int n) {
            String[] stringArray = this.listKey;
            this.listKey = new String[n];
            int n2 = this.listKey.length > stringArray.length ? stringArray.length : this.listKey.length;
            for (int i = 0; i < n2; ++i) {
                this.listKey[i] = stringArray[i];
            }
            stringArray = null;
        }

        public String[] getTitleForIndex(int n) {
            return this.listTitle[n];
        }

        void insert(String string) {
            if (this.pos == this.listKey.length) {
                this.realloc(this.pos + 100);
            }
            this.listKey[this.pos++] = string;
        }

        public String[] insertId(int n, String string) {
            int n2;
            int n3;
            int n4 = 0;
            String[] stringArray = new String[10];
            while (string != null && string.length() != 0) {
                int n5 = string.indexOf(59);
                if (n4 == stringArray.length) {
                    String[] stringArray2 = stringArray;
                    stringArray = new String[n4 + 10];
                    for (n3 = 0; n3 < stringArray2.length; ++n3) {
                        stringArray[n3] = stringArray2[n3];
                    }
                    stringArray2 = null;
                }
                stringArray[n4++] = string.substring(0, n5);
                string = string.substring(1 + n5);
            }
            String[] stringArray3 = stringArray;
            stringArray = new String[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                stringArray[n2] = stringArray3[n2];
            }
            this.listId[n] = stringArray;
            this.listAnchor[n] = new String[stringArray.length];
            for (n2 = 0; n2 < this.listId[n].length; ++n2) {
                if (this.listId[n][n2] == null) {
                    this.listId[n][n2] = "";
                    this.listAnchor[n][n2] = "";
                    continue;
                }
                n3 = this.listId[n][n2].indexOf(35);
                if (n3 != -1) {
                    this.listAnchor[n][n2] = this.listId[n][n2].substring(1 + n3).trim();
                    this.listId[n][n2] = this.listId[n][n2].substring(0, n3).trim();
                    continue;
                }
                this.listAnchor[n][n2] = "";
            }
            this.listTitle[n] = new String[stringArray.length];
            return stringArray;
        }

        public void sort() {
            this.realloc(this.pos);
            Arrays.sort(this.listKey);
            this.listId = new String[this.listKey.length][];
            this.listAnchor = new String[this.listKey.length][];
            this.listTitle = new String[this.listKey.length][];
        }
    }

    private static final class DbFilter
    implements FilenameFilter {
        private DbFilter() {
        }

        public boolean accept(File file, String string) {
            return file.exists() && this.ends(string);
        }

        boolean ends(String string) {
            int n = string.lastIndexOf(46);
            if (!(string.charAt(n + 1) != 'd' && string.charAt(n + 1) != 'D' || string.charAt(n + 2) != 'b' && string.charAt(n + 2) != 'B')) {
                return !string.substring(0, n).toLowerCase().equals("picture");
            }
            return false;
        }
    }

    public static final class StaticModuleInformation {
        private String _startId;
        private String _programSwitch;
        private String _title;
        private String _heading;
        private String _fulltext;

        public StaticModuleInformation(String string, String string2, String string3, String string4, String string5) {
            this._title = string;
            this._startId = string2;
            this._programSwitch = string3;
            this._heading = string4;
            this._fulltext = string5;
        }

        public String get_title() {
            return this._title;
        }

        public String get_id() {
            return this._startId;
        }

        public String get_program() {
            return this._programSwitch;
        }

        public String get_heading() {
            return this._heading;
        }

        public String get_fulltext() {
            return this._fulltext;
        }
    }
}

