/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM c:/OOo_Build/OOD680_m5/moz/wntmsci10.pro/misc/build/mozilla/netwerk/mime/public/nsIMIMEService.idl
 */

#ifndef __gen_nsIMIMEService_h__
#define __gen_nsIMIMEService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIMIMEInfo_h__
#include "nsIMIMEInfo.h"
#endif

#ifndef __gen_nsIURI_h__
#include "nsIURI.h"
#endif

#ifndef __gen_nsIFile_h__
#include "nsIFile.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
#define NS_MIMESERVICE_CID                           \
{ /* 03af31da-3109-11d3-8cd0-0060b0fc14a3 */         \
    0x03af31da,                                      \
    0x3109,                                          \
    0x11d3,                                          \
    {0x8c, 0xd0, 0x00, 0x60, 0xb0, 0xfc, 0x14, 0xa3} \
}

/* starting interface:    nsIMIMEService */
#define NS_IMIMESERVICE_IID_STR "6c424c90-2fe7-11d3-a164-0050041caf44"

#define NS_IMIMESERVICE_IID \
  {0x6c424c90, 0x2fe7, 0x11d3, \
    { 0xa1, 0x64, 0x00, 0x50, 0x04, 0x1c, 0xaf, 0x44 }}

/**
 * The MIME service is responsible for mapping file extensions to MIME-types
 * (see RFC 2045). It also provides access to nsIMIMEInfo interfaces and
 * acts as a general convenience wrapper of nsIMIMEInfo interfaces.
 *
 * The MIME service maintains a database with a <b>one</b> MIME type <b>to many</b>
 * file extensions rule. Adding the same file extension to multiple MIME types
 * is illegal and behavior is undefined.
 *
 * @see nsIMIMEInfo
 */
class NS_NO_VTABLE nsIMIMEService : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IMIMESERVICE_IID)

  /**
     * Retrieves an nsIMIMEInfo using both the extension
     * and the type of a file. The type is given preference
     * during the lookup. One of aMIMEType and aFileExt
     * can be null. At least one of aMIMEType and aFileExt
     * must be non-null and nonempty.
     */
  /* nsIMIMEInfo getFromTypeAndExtension (in string aMIMEType, in string aFileExt); */
  NS_IMETHOD GetFromTypeAndExtension(const char *aMIMEType, const char *aFileExt, nsIMIMEInfo **_retval) = 0;

  /**
     * Retrieves a string representation of the MIME type
     * associated with this file extension.
     *
     * @param  A file extension (excluding the dot ('.')).
     * @return The MIME type, if any.
     */
  /* string getTypeFromExtension (in string aFileExt); */
  NS_IMETHOD GetTypeFromExtension(const char *aFileExt, char **_retval) = 0;

  /**
     * Retrieves a string representation of the MIME type
     * associated with this URI. The association is purely
     * file extension to MIME type based. No attempt to determine
     * the type via server headers or byte scanning is made.
     *
     * @param  The URI the user wants MIME info on.
     * @return The MIME type, if any.
     */
  /* string getTypeFromURI (in nsIURI aURI); */
  NS_IMETHOD GetTypeFromURI(nsIURI *aURI, char **_retval) = 0;

  /* string getTypeFromFile (in nsIFile aFile); */
  NS_IMETHOD GetTypeFromFile(nsIFile *aFile, char **_retval) = 0;

  /**
     * Given a Type/Extension combination, returns the default extension
     * for this type. This may be identical to the passed-in extension.
     *
     * @param aMIMEType The Type to get information on. Must not be null.
     * @param aFileExt  File Extension. Can be null.
     */
  /* string getPrimaryExtension (in string aMIMEType, in string aFileExt); */
  NS_IMETHOD GetPrimaryExtension(const char *aMIMEType, const char *aFileExt, char **_retval) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIMIMESERVICE \
  NS_IMETHOD GetFromTypeAndExtension(const char *aMIMEType, const char *aFileExt, nsIMIMEInfo **_retval); \
  NS_IMETHOD GetTypeFromExtension(const char *aFileExt, char **_retval); \
  NS_IMETHOD GetTypeFromURI(nsIURI *aURI, char **_retval); \
  NS_IMETHOD GetTypeFromFile(nsIFile *aFile, char **_retval); \
  NS_IMETHOD GetPrimaryExtension(const char *aMIMEType, const char *aFileExt, char **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIMIMESERVICE(_to) \
  NS_IMETHOD GetFromTypeAndExtension(const char *aMIMEType, const char *aFileExt, nsIMIMEInfo **_retval) { return _to GetFromTypeAndExtension(aMIMEType, aFileExt, _retval); } \
  NS_IMETHOD GetTypeFromExtension(const char *aFileExt, char **_retval) { return _to GetTypeFromExtension(aFileExt, _retval); } \
  NS_IMETHOD GetTypeFromURI(nsIURI *aURI, char **_retval) { return _to GetTypeFromURI(aURI, _retval); } \
  NS_IMETHOD GetTypeFromFile(nsIFile *aFile, char **_retval) { return _to GetTypeFromFile(aFile, _retval); } \
  NS_IMETHOD GetPrimaryExtension(const char *aMIMEType, const char *aFileExt, char **_retval) { return _to GetPrimaryExtension(aMIMEType, aFileExt, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIMIMESERVICE(_to) \
  NS_IMETHOD GetFromTypeAndExtension(const char *aMIMEType, const char *aFileExt, nsIMIMEInfo **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetFromTypeAndExtension(aMIMEType, aFileExt, _retval); } \
  NS_IMETHOD GetTypeFromExtension(const char *aFileExt, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTypeFromExtension(aFileExt, _retval); } \
  NS_IMETHOD GetTypeFromURI(nsIURI *aURI, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTypeFromURI(aURI, _retval); } \
  NS_IMETHOD GetTypeFromFile(nsIFile *aFile, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTypeFromFile(aFile, _retval); } \
  NS_IMETHOD GetPrimaryExtension(const char *aMIMEType, const char *aFileExt, char **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetPrimaryExtension(aMIMEType, aFileExt, _retval); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsMIMEService : public nsIMIMEService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIMIMESERVICE

  nsMIMEService();

private:
  ~nsMIMEService();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsMIMEService, nsIMIMEService)

nsMIMEService::nsMIMEService()
{
  /* member initializers and constructor code */
}

nsMIMEService::~nsMIMEService()
{
  /* destructor code */
}

/* nsIMIMEInfo getFromTypeAndExtension (in string aMIMEType, in string aFileExt); */
NS_IMETHODIMP nsMIMEService::GetFromTypeAndExtension(const char *aMIMEType, const char *aFileExt, nsIMIMEInfo **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getTypeFromExtension (in string aFileExt); */
NS_IMETHODIMP nsMIMEService::GetTypeFromExtension(const char *aFileExt, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getTypeFromURI (in nsIURI aURI); */
NS_IMETHODIMP nsMIMEService::GetTypeFromURI(nsIURI *aURI, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getTypeFromFile (in nsIFile aFile); */
NS_IMETHODIMP nsMIMEService::GetTypeFromFile(nsIFile *aFile, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* string getPrimaryExtension (in string aMIMEType, in string aFileExt); */
NS_IMETHODIMP nsMIMEService::GetPrimaryExtension(const char *aMIMEType, const char *aFileExt, char **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIMIMEService_h__ */
