// -*- C++ -*-
#ifndef _anthyconv_h_included_
#define _anthyconv_h_included_

#include <vector>
#include <anthy/anthy.h>
#include <anthy/input.h>
#include "kkconv.h"

#define ANTHY_PROC_MASK 512

class AnthyConv : public KKConv{
public:
    virtual ~AnthyConv();
    KKContext *createContext(XimIC *);
    char **getIcon();
    void onPushIcon();
    virtual char *getModeName(int );
private:
};

class AnthyContext : public KKContext{
public:
    AnthyContext(AnthyConv *,XimIC *);
    void OnUpdatePe(pe_stat *);
    int pushKey(keyState *e);
    int getMode();
    void setMode(int mode);
    jstring_t *clear();
    virtual ~AnthyContext();
private:
    int procRawMode(keyState *);
    int procInputMode(keyState *);
    void updateAnthyPreedit();
    void updateCandidates();
    int procCommandKey(keyState *);

    struct anthy_input_context *mAic;
    struct anthy_input_preedit *mPedit;
    Candidates *mCands;
    bool mIsOn;
};

void initAnthy();

#endif
/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 * End:
 */
