<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="UTF-8" />

<xsl:template match="/">
	<xsl:apply-templates select="links" />
</xsl:template>

<xsl:template match="links">
	<table border="1" cellpadding="3" cellspacing="0">
	<tr>
		<th>リンク名</th>
		<th>URL</th>
		<th>更新日</th>
		<th>訪問回数</th>
		<th></th>
		<th></th>
	</tr>
	<xsl:for-each select="link">
		<xsl:sort select="count" order="descending" />
		<tr>
			<td>
				<a>
					<xsl:attribute name="href">countup.waxml?target=<xsl:value-of select="@url" /></xsl:attribute>
					<xsl:value-of select="title" />
				</a>
			</td>
			<td>
				<xsl:value-of select="@url" />
			</td>
			<td align="center">
				<xsl:value-of select="asofdate" />
			</td>
			<td align="right">
				<xsl:value-of select="count" />
			</td>
			<td>
				<a>
					<xsl:attribute name="href">amend.waxml?target=<xsl:value-of select="@url" /></xsl:attribute>
					編集
				</a>
			</td>
			<td>
				<a>
					<xsl:attribute name="href">delete.waxml?target=<xsl:value-of select="@url" /></xsl:attribute>
					削除
				</a>
			</td>
		</tr>
	</xsl:for-each>
	</table>
</xsl:template>

</xsl:stylesheet>
