// $Id: common.cc,v 1.14 2003/06/28 03:36:59 ta_muto Exp $

#include <common.h>

#ifdef _WIN32
	#include <io.h>
	#include <direct.h>
#else
	#include <unistd.h>
	#include <sys/stat.h>
#endif

bool wax::checkBoolean(const xmlChar* value, bool defValue)
{
	if(value == NULL)	return defValue;

	int retValue = defValue;
	if(!xmlStrcasecmp(value, (const xmlChar*)"yes") || !xmlStrcmp(value, (const xmlChar*)"1") || !xmlStrcasecmp(value, (const xmlChar*) "true")) {
		return true;
	}
	if(!xmlStrcasecmp(value, (const xmlChar*)"no") || !xmlStrcmp(value, (const xmlChar*)"0") || !xmlStrcasecmp(value, (const xmlChar*) "false")) {
		return false;
	}
	return retValue;
}

xmlChar* wax::trimPath(const xmlChar* path)
{
	for(int i = (int)xmlStrlen(path); i > 0; i--) {
		if(path[i] == '/' || path[i] == '\\') {
			return xmlStrndup(path, i + 1);
		}
	}
	return xmlStrdup((const xmlChar*)"./");
}

xmlCharEncoding checkCode(const unsigned char* text)
{
	const unsigned char*ptr = text;
	
	for( ; *ptr != '\0'; ptr++) {
		if(*ptr == 0x1b && *(ptr + 1) == '$')	return XML_CHAR_ENCODING_2022_JP;
		if(*ptr < 0x80)	continue;
		if(0x81 <= *ptr && *ptr <= 0x9F)	return XML_CHAR_ENCODING_SHIFT_JIS;
		if(0xA1 <= *ptr && *ptr <= 0xDF)	return XML_CHAR_ENCODING_EUC_JP;
		if(*(ptr+1) <= 0xA0)	return XML_CHAR_ENCODING_SHIFT_JIS;
	}
	return XML_CHAR_ENCODING_ASCII;
}

#if LE==1 || NOTICONV==1
xmlChar* wax::C2UTF8(const char* text)
{
	return xmlStrdup((const xmlChar*)text);
}
#else
// copy from encoding.c in libxml2
static int
xmlIconvWrapper(iconv_t cd,
    unsigned char *out, int *outlen,
    const unsigned char *in, int *inlen) {

    size_t icv_inlen = *inlen, icv_outlen = *outlen;
    const char *icv_in = (const char *) in;
    char *icv_out = (char *) out;
    int ret;

#ifdef _WIN32
    ret = iconv(cd, (const char **) &icv_in, &icv_inlen, &icv_out, &icv_outlen);
#else
    ret = iconv(cd, (char **) &icv_in, &icv_inlen, &icv_out, &icv_outlen);
#endif

    if (in != NULL) {
        *inlen -= icv_inlen;
        *outlen -= icv_outlen;
    } else {
        *inlen = 0;
        *outlen = 0;
    }
    if ((icv_inlen != 0) || (ret == -1)) {
#ifdef EILSEQ
        if (errno == EILSEQ) {
            return -2;
        } else
#endif
#ifdef E2BIG
        if (errno == E2BIG) {
            return -1;
        } else
#endif
#ifdef EINVAL
        if (errno == EINVAL) {
            return -3;
        } else
#endif
        {
            return -3;
        }
    }
    return 0;
}

xmlChar* intrC2UTF8(const unsigned char* text, xmlCharEncoding enc)
{
	xmlCharEncodingHandlerPtr handler = xmlGetCharEncodingHandler(enc);
	if(handler == NULL) {
		return xmlStrdup(text);
	}
	int inlen = strlen((const char*)text);
	int outlen = (inlen + 1) * 3 - 1;
	unsigned char* out = new unsigned char[outlen];
	if(out == NULL) { // sorry, Out of memory.
		return xmlStrdup(text); // try to return.
	}
	int temp = inlen;
	int ret;
	if(handler->input != NULL) {
		ret = handler->input(out, &outlen, text, &temp);
	} else if(handler->iconv_in) {
		ret = xmlIconvWrapper(handler->iconv_in, out, &outlen, text, &temp);
		out[outlen] = '\0';
	} else { // oops!
		delete [] out;
		return xmlStrdup(text); // try to return.
	}
	if(ret || temp - inlen) {
		delete [] out;
		return xmlStrdup(text);
	}
	xmlChar* retStr = xmlStrdup(out);
	delete [] out;
	return retStr;
}

xmlChar* wax::C2UTF8(const char* text)
{
	xmlCharEncoding enc = xmlDetectCharEncoding((const unsigned char*)text, strlen(text));
	if(enc == XML_CHAR_ENCODING_NONE) {
		enc = checkCode((const unsigned char*)text);
	}
	return intrC2UTF8((const unsigned char*)text, enc);
}
#endif


void wax::sleepTimer(int second)
{
#ifdef _WIN32
		_sleep(second);
#else
		sleep(second);
#endif
}

bool wax::makeDir(const xmlChar* dirName)
{
#ifdef _WIN32
	if(_mkdir((const char*) dirName) == 0)	return true;
	return false;
#else
	if(mkdir((const char*) dirName, 0755) == 0)	return true;
	return false;
#endif
}

void wax::removeDir(const xmlChar* dirName)
{
#ifdef _WIN32
	_rmdir((const char*) dirName);
#else
	rmdir((const char*) dirName);
#endif
}

void wax::commonInit()
{
	xmlInitMemory();
	xmlSubstituteEntitiesDefault(0);
	xmlKeepBlanksDefault(0);
	xmlXPathInit();

#ifndef _WIN32
	umask(0);
#endif
}

void wax::commonExit()
{
	xsltCleanupGlobals();
	xmlCleanupParser();
}
