// $Id: CWaxLibs.h,v 1.3 2003/09/17 02:57:53 ta_muto Exp $
//

#ifndef __wax_CWaxLibs_h
#define __wax_CWaxLibs_h

#include <common.h>
#include <collection.h>
#include <CEnvironment.h>

namespace wax {
	class CWaxLibs {
	public:
		static xmlChar* parseLocation(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns, CCollection* params);
	
		static bool parseWithParam(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns, CCollection* params);
		static void matchParameter(CEnvironment* runenv, CCollection* params);
		static void addParameter(CCollection* params, const xmlChar* name, const xmlChar* value, bool fixed);
	
		static bool parseCommon(CEnvironment* runenv, xmlNodePtr cur, xmlChar*& content);
		static bool parseAsContent(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns, xmlChar*& content);
		
		static xmlChar* evaluateXPath(const xmlChar* connect, CCollection& vars, const xmlChar* expr);
		static xmlChar* evaluateXPath(xmlDocPtr doc, CCollection& vars, const xmlChar* expr);
	private:
		static xmlChar* parseLocationInternal(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns, CCollection* params);
		static bool parseWithParamInternal(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns, CCollection* params);
	} ;
}

#endif
