// $Id: CParameterItem.cc,v 1.1 2003/08/27 06:08:53 ta_muto Exp $

#include <CParameterItem.h>

wax::CParameterItem::CParameterItem(const xmlChar* initName, const xmlChar* initValue, bool initFixed)
{
	if(initName != NULL) {
		name = xmlStrdup(initName);
	} else {
		name = NULL;
	}
	if(initValue != NULL) {
		origin = xmlStrdup(initValue);
		value = quoteStrdup(initValue);
	} else {
		origin = NULL;
		value = NULL;
	}
	fixed = initFixed;
}

wax::CParameterItem::~CParameterItem()
{
	if(name != NULL)	xmlFree(name);
	if(value != NULL)	xmlFree(value);
	if(origin != NULL)	xmlFree(origin);
}

void wax::CParameterItem::setOriginalValue(const xmlChar* newValue)
{
	if(fixed == true)	return; // safety lock.

	if(value != NULL)	xmlFree(value);
	if(origin != NULL)	xmlFree(origin);
	if(newValue != NULL) {
		origin = xmlStrdup(newValue);
		value = quoteStrdup(newValue);
	} else {
		value = NULL;
		origin = NULL;
	}
}

xmlChar* wax::CParameterItem::quoteStrdup(const xmlChar* newValue)
{
	xmlChar* retValue = NULL;
	if(newValue != NULL) {
		if(xmlStrchr(newValue, '"')) {
			if(xmlStrchr(newValue, '\'')) {
				return NULL;
			} else {
				retValue = xmlStrdup((const xmlChar*)"'");
				retValue = xmlStrcat(retValue, newValue);
				retValue = xmlStrcat(retValue, (const xmlChar*)"'");
			}
		} else {
			retValue = xmlStrdup((const xmlChar*)"\"");
			retValue = xmlStrcat(retValue, newValue);
			retValue = xmlStrcat(retValue, (const xmlChar*)"\"");
		}
	}
	return retValue;
}
