// $Id: CWaxLibs.cc,v 1.5 2003/11/23 02:11:23 ta_muto Exp $

#include <CWaxLibs.h>
#include <CXmlLibs.h>

#include <CRequest.h>
#include <CFileReader.h>

xmlChar* wax::CWaxLibs::parseLocation(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns, CCollection* params)
{
	cur = cur->children;
	while(cur != NULL) {
		if(cur->ns == ns) {
			if(!xmlStrcmp(cur->name, (const xmlChar*) "location")) {
				xmlChar* path = parseLocationInternal(runenv, cur, ns, params);
				if(path != NULL) {
					if(xmlStrstr(path, (const xmlChar*) "./") != NULL ||
					   xmlStrstr(path, (const xmlChar*) ".\\") != NULL) {
						xmlFree(path);
						return NULL;
					}
				}
				return path;
			}
		}
		cur = cur->next;
	}
	return NULL;
}

xmlChar* wax::CWaxLibs::parseLocationInternal(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns, CCollection* params)
{
	xmlChar* href = NULL;
	cur = cur->children;
	while(cur != NULL) {
		if(cur->ns == ns) {
			if(href == NULL && !xmlStrcmp(cur->name, (const xmlChar*) "href")) {
				if(parseAsContent(runenv, cur->children, ns, href) == false) {
					if(href != NULL)	xmlFree(href);
					return NULL;
				}
			}
			if(parseWithParamInternal(runenv, cur, ns, params) == false) {
				if(href != NULL)	xmlFree(href);
				return NULL;
			}
		}
		cur = cur->next;
	}
	return href;
}

bool wax::CWaxLibs::parseWithParam(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns, CCollection* params)
{
	cur = cur->children;
	while(cur != NULL) {
		if(cur->ns == ns) {
			if(parseWithParamInternal(runenv, cur, ns, params) == false) {
				return false;
			}
		}
		cur = cur->next;
	}
	return true;
}

bool wax::CWaxLibs::parseWithParamInternal(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns, CCollection* params)
{
	if(!xmlStrcmp(cur->name, (const xmlChar*) "with-param")) {
		CXmlStr name(xmlGetProp(cur, (const xmlChar*)"name"));
		if(name.value() == NULL) {
			IError::message(ERR_ATTRIBUTE, "with-param::name");
			return false;
		}
		CXmlStr fixed(xmlGetProp(cur, (const xmlChar*) "fixed"));
		CXmlStr value(xmlGetProp(cur, (const xmlChar*) "value"));
		if(value.value() == NULL) {
			xmlChar* content = NULL;
			if(parseAsContent(runenv, cur->children, ns, content) == false) {
				return false;
			}
			addParameter(params, name.value(), content, checkBoolean(fixed.value(), false));
		} else {
			addParameter(params, name.value(), value.value(), checkBoolean(fixed.value(), false));
		}
	}
	return true;
}

void wax::CWaxLibs::matchParameter(CEnvironment* runenv, CCollection* params)
{
	CRequest* request = runenv->getRequest();
	if(request == NULL)	return;
	
	CParameterItem* seek = (CParameterItem*) params->getHead();
	while(seek != NULL) {
		if(seek->getFixed() == false) {
			CParameterItem* item = request->findParameter(seek->getName(), runenv->getPoint());
			if(item != NULL) {
				seek->setOriginalValue(item->getOriginalValue());
			}
		}
		seek = (CParameterItem*)seek->getNext();
	}
}

void wax::CWaxLibs::addParameter(CCollection* params, const xmlChar* name, const xmlChar* value, bool fixed)
{
	params->addItem(new CParameterItem(name, value, fixed));
}

bool wax::CWaxLibs::parseCommon(CEnvironment* runenv, xmlNodePtr cur, xmlChar*& content)
{
	content = NULL;
	if(!xmlStrcmp(cur->name, (const xmlChar*) "param-of")) {
		CXmlStr name(xmlGetProp(cur, (const xmlChar*) "name"));
		CXmlStr defValue(xmlGetProp(cur, (const xmlChar*) "default"));
		if(name.value() == NULL) {
			IError::message(ERR_ATTRIBUTE, "param-of::name");
			return false;
		}
		CRequest* request = runenv->getRequest();
		if(request == NULL) {
			IError::message(ERR_OUTOFMEMORY, LOCATION);
			return false;
		}
		CParameterItem* param = request->findParameter(name.value(), runenv->getPoint());
		if(param == NULL) {
			if(defValue.value() == NULL) {
				IError::message(ERR_NOTFOUNDPARAM, name.value());
				return false;
			}
			content = xmlStrdup(defValue.value());
		} else {
			content = xmlStrdup(param->getOriginalValue());
		}
	} else if(!xmlStrcmp(cur->name, (const xmlChar*) "system")) {
		CXmlStr environment(xmlGetProp(cur, (const xmlChar*) "environment"));
		if(environment.value() != NULL) {
			char* e = getenv((const char*) environment.value());
			if(e != NULL) {
				content = xmlStrdup((const xmlChar*)e);
			}
		} else {
			CXmlStr dateFormat(xmlGetProp(cur, (const xmlChar*) "now"));
			if(dateFormat.value() != NULL) {
				content = CXmlLibs::getDateTime(dateFormat.value());
			}
		}
	}
	return true;
}

bool wax::CWaxLibs::parseAsContent(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns, xmlChar*& content)
{
	while(cur != NULL) {
		if(cur->ns == ns) {
			xmlChar* value = NULL;
			if(parseCommon(runenv, cur, value) == false) {
				return false;
			}
			if(value != NULL) {
				if(content == NULL) {
					content = xmlStrdup(value);
				} else {
					content = xmlStrcat(content, value);
				}
				xmlFree(value);
			}
		} else {
			switch(cur->type){
			case XML_TEXT_NODE:
				if(cur->content != NULL) {
					if(content == NULL) {
						content = xmlStrdup(cur->content);
					} else {
						content = xmlStrcat(content, cur->content);
					}
				}
				break;
			}
		}
		cur = cur->next;
	}
	return true;
}

xmlChar* wax::CWaxLibs::evaluateXPath(const xmlChar* connect, CCollection& vars, const xmlChar* expr)
{
	if(connect == NULL) {
		IError::message(ERR_CONNECT);
		return NULL;
	}
	CFileReader reader(connect);
	xmlDocPtr doc = CXmlLibs::read(&reader);
	if(doc == NULL)	return NULL;
	xmlChar* ret = evaluateXPath(doc, vars, expr);
	xmlFreeDoc(doc);
	return ret;
}

xmlChar* wax::CWaxLibs::evaluateXPath(xmlDocPtr doc, CCollection& vars, const xmlChar* expr)
{
	CXPathMacro macro(doc);
	
	CParameterItem* item = (CParameterItem*) vars.getHead();
	while(item != NULL) {
		macro.registerVariable(item->getName(), item->getOriginalValue());
		item = (CParameterItem*) item->getNext();
	}
	if(macro.evaluate(expr) == false) {
		IError::message(ERR_XPATH);
		return NULL;
	}
	return macro.getString();
}
