// $Id: CIncludeTask.cc,v 1.12 2003/11/23 02:11:23 ta_muto Exp $

#include <views/CIncludeTask.h>
#include <CFileReader.h>
#include <CWaxLibs.h>

wax::CIncludeTask::CIncludeTask()
{
	reader = NULL;
}

wax::CIncludeTask::~CIncludeTask()
{
	if(reader != NULL)	delete reader;
}

bool wax::CIncludeTask::parse(CEnvironment* runenv, xmlNodePtr cur)
{
	CXmlStr uri(xmlGetProp(cur, (const xmlChar*) "uri"));
	if(uri.value() == NULL) {
		CCollection params;
		xmlNsPtr ns = xmlSearchNsByHref(runenv->getDocPtr(), cur, CEnvironment::WAX);
		uri.replace(CWaxLibs::parseLocation(runenv, cur, ns, &params));
		if(uri.value() == NULL) {
			IError::message(ERR_ATTRIBUTE, "include::uri");
			return false;
		}
	}
	CXmlStr path(runenv->makePath(uri.value()));
	reader = runenv->getReader(path.value());
	if(reader == NULL) {
		IError::message(ERR_OUTOFMEMORY, LOCATION);
		return false;
	}
	return true;
}

bool wax::CIncludeTask::execute()
{
	bool ret = reader->open();
	if(ret == false) {
		IError::message(ERR_EXISTFILE, reader->getPath());
	}
	return ret;
}

void wax::CIncludeTask::output(IWriter* writer)
{
	int size;
	char buffer[1024];
	while((size = reader->read(buffer, 1024)) > 0) {
		writer->write(buffer, size);
	}
	reader->close();
}
