package weber_4_0_sample.org.itscool.json;

import org.itscool.commons.document.BeanToJsonDocument;
import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucket;
import org.itscool.weber.controller.Globals;

public class JsonSampleAction extends Action {
	public static final String LINE=System.getProperty("line.separator");
	
	public String doExecute(ActionBucket bucket)throws Exception{
		Item item = new Item();
		BeanToJsonDocument beanToXml = new BeanToJsonDocument("item");
		
		item.setItemCode(91);
		item.setItemName("[");
		item.setItemPrice(300);
		beanToXml.addElement(item);
		
		item.setItemCode(94);
		item.setItemName("X[");
		item.setItemPrice(290);
		beanToXml.addElement(item);
		
		String text = beanToXml.parseText();
		System.out.println(text);
		bucket.print(text);
		
		return Globals.RET_NOFORWARD;
	}
	
	public String doExecute_BAK(ActionBucket bucket)throws Exception{
		StringBuffer sb = new StringBuffer();
		sb.append("{\"item\":[");
         sb.append("{\"itemCode\":91,");
         sb.append("\"itemName\":\"[\",");
         sb.append("\"itemPrice\":300},");

         sb.append("{\"itemCode\":94,");
        		 sb.append("\"itemName\":\"X[\",");
         sb.append("\"itemPrice\":290},");

         sb.append("{\"itemCode\":95,");
         sb.append("\"itemName\":\"؍[\",");
         sb.append("\"itemPrice\":320}");
         sb.append("]");
		 sb.append("}");
		
		System.out.println(sb.toString());
		bucket.print(sb.toString());
		
		return Globals.RET_NOFORWARD;
	}
}