/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.itscool.commons.bean.BeanFactory;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;
import org.itscool.commons.collection.InitParamMap;
import org.itscool.commons.dao.EntityInfoMapping;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.request.GeneralFormFactory;
import org.itscool.commons.request.UploadFile;
import org.itscool.commons.util.DateFormatUtil;
import org.itscool.weber.action.Action;
import org.itscool.weber.action.ActionBucketImpl;
import org.itscool.weber.io.ActionConfigReader;
import org.itscool.weber.io.ExceptionConfigReader;
import org.itscool.weber.io.MessageConfigReader;
import org.itscool.weber.mapping.ActionMapping;
import org.itscool.weber.mapping.ActionMappings;
import org.itscool.weber.mapping.ExceptionMapping;
import org.itscool.weber.mapping.ExceptionMappings;
import org.itscool.weber.mapping.MessageMappings;
import org.itscool.weber.user.UserManager;

public class FrontServlet
extends HttpServlet {
    protected AbstractLog log;
    protected ServletConfig config = null;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$List;

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        BeanFactory factory = BeanFactory.getInstance();
        if (!factory.isInit()) {
            try {
                factory.createForUrl("di-config.xml");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new ServletException(ex.getMessage());
            }
        }
        try {
            if (factory.isDefined("Log")) {
                this.log = (AbstractLog)factory.getInstance("Log");
                if (!this.log.isInit()) {
                    this.log = (AbstractLog)factory.createInstance("Log");
                }
            } else {
                this.log = SimpleLog.getInstance();
            }
        }
        catch (Exception ioe) {
            throw new ServletException(ioe.getMessage());
        }
        this.initConfig(factory);
    }

    protected void initConfig(BeanFactory factory) throws ServletException {
        try {
            ActionMappings actionMappings = ActionMappings.getInstance();
            ExceptionMappings exception = ExceptionMappings.getInstance();
            MessageMappings messages = MessageMappings.getInstance();
            InitParamMap params = (InitParamMap)factory.createInstance("InitParams");
            String weberConf = params.getParam("weber-config");
            if (weberConf == null) {
                String msg = "no define \"weber-config\" path from diconfig.xml[InitParams]";
                this.log.error(msg);
                throw new IOException(msg);
            }
            String msgConf = params.getParam("message-config");
            ActionConfigReader actionReader = new ActionConfigReader();
            actionReader.setConfigName(weberConf);
            actionReader.create(actionMappings);
            try {
                ExceptionConfigReader exceptionReader = new ExceptionConfigReader();
                exceptionReader.setConfigName(weberConf);
                exceptionReader.create(exception);
            }
            catch (Exception ioe) {
                this.log.info("ExceptionConfigReader\u306f\u5b9f\u884c\u3055\u308c\u307e\u305b\u3093");
            }
            try {
                MessageConfigReader messageReader = new MessageConfigReader();
                messageReader.setConfigName(msgConf);
                messageReader.create(messages);
            }
            catch (Exception ioe) {
                this.log.info("MessageConfigReader\u306f\u5b9f\u884c\u3055\u308c\u307e\u305b\u3093");
            }
            try {
                EntityInfoMapping daoMapping = (EntityInfoMapping)factory.createInstance("EntityInfoMapping");
            }
            catch (Exception ioe) {
                this.log.info("DaoConfigReader\u306f\u5b9f\u884c\u3055\u308c\u307e\u305b\u3093");
            }
            try {
                UserManager roleManager = (UserManager)factory.createInstance("UserManager");
                roleManager.init();
            }
            catch (Exception ioe) {
                this.log.info("WeberUserManager\u306f\u5b9f\u884c\u3055\u308c\u307e\u305b\u3093");
            }
        }
        catch (Exception e) {
            String name1 = e.getClass().getName();
            String name2 = Exception.class.getName();
            StackTraceElement[] traceList = e.getStackTrace();
            this.log.error(this.getStackTrace(traceList));
            throw new ServletException(e.getMessage());
        }
    }

    public void doGet(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.execute(arg0, arg1);
    }

    public void doPost(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.execute(arg0, arg1);
    }

    private void execute(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block15: {
            try {
                String jsp = this.invoke(req, res);
                if (jsp.equals("noforward")) {
                    return;
                }
                try {
                    RequestDispatcher rd = req.getRequestDispatcher(jsp);
                    rd.forward((ServletRequest)req, (ServletResponse)res);
                }
                catch (IOException e) {
                    String msg = jsp + "\u306b\u6307\u5b9a\u3055\u308c\u305f\u30b3\u30f3\u30c6\u30f3\u30c4\u306e\u547c\u51fa\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\n" + e.getMessage();
                    throw new IOException(msg);
                }
            }
            catch (IOException e) {
                String name1 = e.getClass().getName();
                String name2 = IOException.class.getName();
                if (!this.exception(req, res, name1, name2, e)) {
                    throw e;
                }
            }
            catch (ServletException e) {
                String name1 = ((Object)((Object)e)).getClass().getName();
                String name2 = ServletException.class.getName();
                if (!this.exception(req, res, name1, name2, (Exception)((Object)e))) {
                    throw e;
                }
            }
            catch (NullPointerException e) {
                String name1 = e.getClass().getName();
                String name2 = NullPointerException.class.getName();
                if (!this.exception(req, res, name1, name2, e)) {
                    throw e;
                }
            }
            catch (RuntimeException e) {
                String name1 = e.getClass().getName();
                String name2 = RuntimeException.class.getName();
                if (!this.exception(req, res, name1, name2, e)) {
                    throw e;
                }
            }
            catch (Exception e) {
                String name1 = e.getClass().getName();
                String name2 = Exception.class.getName();
                if (!this.exception(req, res, name1, name2, e)) {
                    throw new ServletException(e.getMessage());
                }
            }
            catch (Error e) {
                String name1 = e.getClass().getName();
                String name2 = Exception.class.getName();
                if (this.exception(req, res, name1, name2, e)) break block15;
                throw new ServletException(e.getMessage());
            }
        }
    }

    protected String invoke(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String jsp = this.process(req, res);
        return jsp;
    }

    protected String process(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String ret = "success";
        String jsp = null;
        String encode = this.getEncoding();
        GeneralFormFactory factory = GeneralFormFactory.getInstance();
        GeneralForm hgForm = factory.create(req, encode);
        String path = req.getServletPath();
        String pathInfo = req.getPathInfo();
        if (pathInfo != null) {
            path = pathInfo;
        }
        this.log.trace("---------- servlet infomation!!! --------------- ");
        this.log.trace("[ServerName]" + req.getServerName());
        this.log.trace("[ContextPath]" + req.getContextPath());
        this.log.trace("[ServletPath]" + req.getServletPath());
        this.log.trace("[PathInfo]" + req.getPathInfo());
        this.log.trace("[QueryString]" + req.getQueryString());
        this.log.trace("[RequestURI]" + req.getRequestURI());
        this.log.trace("[RequestURL]" + req.getRequestURL());
        Action action = this.getAction(req, path);
        if (action == null) {
            String err = "[" + path + "]" + "Can not found action (" + FrontServlet.class.getName() + ")";
            throw new ServletException(err);
        }
        HashMap roles = this.getRoles(path);
        ActionBucketImpl bucket = new ActionBucketImpl();
        bucket.setServlet(this);
        bucket.setRequest(req);
        bucket.setResponse(res);
        bucket.setRoles(roles);
        action.init(bucket, hgForm);
        ret = action.beforeExecute();
        if (!ret.equals("success")) {
            if (ret.equals("noforward")) {
                return ret;
            }
            jsp = this.getForward(action, ret, path);
            if (jsp == null) {
                String err = "[ACTION:" + action.getClass().getName() + "NAME:" + ret + "]" + "Can not found forward (" + FrontServlet.class.getName() + ")";
                throw new ServletException(err);
            }
            return jsp;
        }
        Object[] bean = this.getForm(path);
        String bean_maped_kind = (String)hgForm.getParameter("bean_maped_kind");
        if (bean == null) {
            bean = hgForm;
        } else if (bean_maped_kind == null || bean_maped_kind.length() == 0 || bean_maped_kind.equals("bean")) {
            this.setRequestParam(bean, hgForm);
        } else if (bean_maped_kind.equals("list")) {
            bean = this.setRequestParameBeanToList(bean, hgForm);
        } else if (bean_maped_kind.equals("array")) {
            bean = this.setRequestParameBeanToArray(bean, hgForm);
        }
        action.setForm(bean);
        ret = action.execute();
        if (ret != null && ret.equals("noforward")) {
            return "noforward";
        }
        jsp = this.getForward(action, ret, path);
        return jsp;
    }

    protected String getEncoding() {
        BeanFactory factory = BeanFactory.getInstance();
        InitParamMap params = (InitParamMap)factory.getInstance("InitParams");
        String encode = params.getParam("encoding");
        return encode;
    }

    protected String getForward(Action action, String ret, String path) throws ServletException {
        String jsp = action.getForward(ret);
        if (jsp == null) {
            String err = "[ACTION:" + action.getClass().getName() + "NAME:" + ret + "] Can not found forward (" + FrontServlet.class.getName() + ")";
            throw new ServletException(err);
        }
        return jsp;
    }

    protected String getStackTrace(StackTraceElement[] traceList) {
        String LINE = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < traceList.length; ++i) {
            StackTraceElement trace = traceList[i];
            sb.append(trace.toString()).append(LINE);
        }
        return sb.toString();
    }

    protected boolean exception(HttpServletRequest req, HttpServletResponse res, String exceptionName1, String exceptionName2, Exception e) throws IOException, ServletException {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.getClass().getName();
        }
        this.log.error(msg);
        StackTraceElement[] traceList = e.getStackTrace();
        this.log.error(this.getStackTrace(traceList));
        String jsp = this.getExceptionPage(e);
        if (jsp != null) {
            req.setAttribute("org.itscool.weber.action.SYSTEM_ERROR_MSG", (Object)msg);
            req.setAttribute("org.itscool.weber.action.SYSTEM_ERROR", (Object)traceList);
            RequestDispatcher rd = req.getRequestDispatcher(jsp);
            rd.forward((ServletRequest)req, (ServletResponse)res);
            return true;
        }
        return false;
    }

    protected boolean exception(HttpServletRequest req, HttpServletResponse res, String exceptionName1, String exceptionName2, Error e) throws IOException, ServletException {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.getClass().getName();
        }
        this.log.error(msg);
        StackTraceElement[] traceList = e.getStackTrace();
        this.log.error(this.getStackTrace(traceList));
        String jsp = this.getExceptionPage(e);
        if (jsp != null) {
            req.setAttribute("org.itscool.weber.action.SYSTEM_ERROR_MSG", (Object)msg);
            req.setAttribute("org.itscool.weber.action.SYSTEM_ERROR", (Object)traceList);
            RequestDispatcher rd = req.getRequestDispatcher(jsp);
            rd.forward((ServletRequest)req, (ServletResponse)res);
            return true;
        }
        return false;
    }

    protected String getExceptionPage(Object e) {
        ExceptionMappings mapping = ExceptionMappings.getInstance();
        ExceptionMapping exception = null;
        exception = e instanceof Exception ? mapping.get((Exception)e) : mapping.get((Error)e);
        if (exception == null) {
            return null;
        }
        return exception.getPath();
    }

    public Action getAction(HttpServletRequest req, String path) throws IOException {
        ActionMappings mappings = ActionMappings.getInstance();
        ActionMapping mapping = (ActionMapping)mappings.get(path);
        if (mapping == null) {
            String err = "Not found action for path(" + path + ")";
            throw new IOException(err);
        }
        Action action = (Action)BeanUtil.createInstance((String)mapping.getType());
        if (this.log.getLevel().equals("trace")) {
            HashMap roles = mapping.getRoles();
            StringBuffer roleNames = new StringBuffer();
            if (roles != null) {
                Set keySet = roles.keySet();
                Iterator it = keySet.iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    roleNames.append(roles.get(key).toString());
                    if (!it.hasNext()) continue;
                    roleNames.append(", ");
                }
            } else {
                roleNames.append("null");
            }
            this.log.trace("---------- request recieved!!!!! --------------- ");
            this.log.trace("PATH   : " + mapping.getPath());
            this.log.trace("ACTION : " + mapping.getType());
            this.log.trace("FORM   : " + mapping.getName());
            this.log.trace("ROLE   : " + roleNames.toString());
        }
        action.setForwards(mapping.getForwards());
        action.setValidates(mapping.getValidates());
        return action;
    }

    public Object getForm(String path) throws IOException {
        ActionMappings mappings = ActionMappings.getInstance();
        ActionMapping mapping = (ActionMapping)mappings.get(path);
        String beanName = mapping.getName();
        if (beanName == null) {
            return null;
        }
        Object bean = BeanUtil.createInstance((String)beanName);
        return bean;
    }

    public Object[] setRequestParameBeanToArray(Object bean, GeneralForm gForm) throws IOException {
        List beanList = this.setRequestParameBeanToList(bean, gForm);
        return beanList.toArray();
    }

    public List setRequestParameBeanToList(Object bean, GeneralForm gForm) throws IOException {
        ArrayList<Object> beanList = new ArrayList<Object>();
        String clazzName = bean.getClass().getName();
        Set keySet = gForm.keySet();
        Iterator it = keySet.iterator();
        boolean isCreateNewBeanFlg = false;
        while (it.hasNext()) {
            String paramName = (String)it.next();
            Object paramValues = gForm.getParameter(paramName);
            if (!(paramValues instanceof List)) continue;
            List list = (List)paramValues;
            int beanNum = list.size();
            for (int i = 0; i < beanNum; ++i) {
                Object beanElement = null;
                if (!isCreateNewBeanFlg) {
                    beanElement = BeanUtil.createInstance((String)clazzName);
                    beanList.add(beanElement);
                } else {
                    if (i >= beanList.size()) continue;
                    beanElement = beanList.get(i);
                }
                Object paramValue = list.get(i);
                Class clazz = BeanUtil.getReturnType((Object)bean, (String)paramName);
                try {
                    if ((class$java$util$Date == null ? FrontServlet.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(clazz) && paramValue instanceof String) {
                        Date date = DateFormatUtil.parse((String)paramValue.toString());
                        if (date == null) continue;
                        BeanUtil.setProperty((Object)beanElement, (String)paramName, (Object)date);
                        continue;
                    }
                    BeanUtil.setProperty((Object)beanElement, (String)paramName, paramValue);
                    continue;
                }
                catch (BeanUtilRuntimeException e) {
                    // empty catch block
                }
            }
            isCreateNewBeanFlg = true;
        }
        if (!isCreateNewBeanFlg && beanList.size() == 0) {
            this.setRequestParam(bean, gForm);
            beanList.add(bean);
        }
        return beanList;
    }

    public void setRequestParam(Object bean, GeneralForm gForm) throws IOException {
        Set keySet = gForm.keySet();
        Iterator it = keySet.iterator();
        if (it.hasNext()) {
            this.log.trace("---------- request parameter!!!! --------------- ");
        }
        while (it.hasNext()) {
            String paramName = (String)it.next();
            Object paramValue = gForm.getParameter(paramName);
            try {
                Class clazz = BeanUtil.getReturnType((Object)bean, (String)paramName);
                if ((class$java$util$List == null ? FrontServlet.class$("java.util.List") : class$java$util$List).isAssignableFrom(clazz) && !(class$java$util$List == null ? FrontServlet.class$("java.util.List") : class$java$util$List).isAssignableFrom(paramValue.getClass())) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(paramValue);
                    BeanUtil.setProperty((Object)bean, (String)paramName, list);
                } else if ((class$java$util$Date == null ? FrontServlet.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(clazz) && paramValue instanceof String) {
                    Date date = DateFormatUtil.parse((String)paramValue.toString());
                    if (date != null) {
                        BeanUtil.setProperty((Object)bean, (String)paramName, (Object)date);
                    }
                } else if (paramValue instanceof String || paramValue instanceof UploadFile || paramValue instanceof List) {
                    BeanUtil.setProperty((Object)bean, (String)paramName, (Object)paramValue);
                } else {
                    throw new ClassCastException(paramName + " is not match [" + clazz.getName() + "] but was [" + paramValue.getClass().getName() + "]");
                }
                this.log.trace(paramName + " = " + paramValue);
            }
            catch (BeanUtilRuntimeException e) {}
        }
    }

    public HashMap getRoles(String path) {
        ActionMappings actionMappings = ActionMappings.getInstance();
        ActionMapping actionMapping = (ActionMapping)actionMappings.get(path);
        if (actionMapping.getRoles() == null) {
            return null;
        }
        HashMap roles = actionMapping.getRoles();
        return roles;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }
}

