/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.connection;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.itscool.commons.connection.ConnectionManager;
import org.itscool.commons.connection.ProxyConnection;
import org.itscool.commons.connection.Transaction;
import org.itscool.commons.connection.TransactionException;

public class DataSourceConnectionManager
implements ConnectionManager {
    private static DataSourceConnectionManager instance = null;
    private String dsName;
    private DataSource ds;
    private boolean mode = false;
    private boolean showSql = false;
    private boolean initFlg = false;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DataSource Name:").append(this.dsName);
        sb.append(", ");
        sb.append("mode:").append(this.mode);
        sb.append(", ");
        sb.append("showSql:").append(this.showSql);
        return sb.toString();
    }

    public static DataSourceConnectionManager getInstance() {
        if (instance == null) {
            instance = new DataSourceConnectionManager();
        }
        return instance;
    }

    public boolean isInit() {
        return this.initFlg;
    }

    public void init() {
        try {
            InitialContext ic = new InitialContext();
            this.ds = (DataSource)ic.lookup(this.dsName);
            this.initFlg = true;
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
    }

    public Transaction getTransaction() {
        Transaction trn = null;
        try {
            Connection con = this.ds.getConnection();
            con = ProxyConnection.createProxy(con);
            con.setAutoCommit(this.mode);
            trn = new Transaction(con);
            trn.setShowSql(this.showSql);
        }
        catch (SQLException se) {
            throw new TransactionException(se);
        }
        return trn;
    }

    public void returnTransaction(Transaction trn) {
        trn.close();
        trn = null;
    }

    public void destroy() {
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public boolean getShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
    }

    public boolean getMode() {
        return this.mode;
    }
}

