/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.weber.action;

import java.util.HashMap;
import java.util.List;
import org.itscool.commons.request.GeneralForm;
import org.itscool.commons.util.InputCheckUtil;
import org.itscool.weber.mapping.MessageMappings;
import org.itscool.weber.mapping.ValidationMapping;

public class Validation {
    private static Validation instance = new Validation();
    public static final String ZENKAKU = "zenkaku";
    public static final String HANKAKU = "hankaku";
    public static final String DIGIT = "digit";
    public static final String EISU = "eisu";
    public static final String EIJI = "eiji";
    public static final String HANKAKU_KANA = "hankaku_kana";
    public static final String DIGIT_LENGTH = "digit_length";
    public static final String STR_LENGTH = "str_length";
    public static final String REQUIRD = "requird";
    public static final String MAIL = "mail";
    public static final String TEL = "tel";
    public static final String POST = "post";
    public static final String URL = "url";

    public static Validation getInstance() {
        return instance;
    }

    public HashMap isValidate(List validates, GeneralForm request) {
        HashMap errList = new HashMap();
        if (validates == null) {
            return errList;
        }
        int size = validates.size();
        for (int i = 0; i < size; ++i) {
            Object value;
            ValidationMapping validation = (ValidationMapping)validates.get(i);
            String paramName = validation.getParamName();
            if (validation == null || !((value = request.getParameter(paramName)) instanceof String)) continue;
            this.validate(errList, paramName, validation, (String)value);
        }
        return errList;
    }

    protected void validate(HashMap errList, String paramName, ValidationMapping validation, String value) {
        String type = validation.getType();
        String msgkey = validation.getMsgkey();
        String msgbody = validation.getMsgbody();
        double max = validation.getMax();
        double min = validation.getMin();
        int length = validation.getLength();
        boolean ret = true;
        if (type.equals(ZENKAKU)) {
            ret = InputCheckUtil.checkFullSize((String)value);
        } else if (type.equals(HANKAKU)) {
            ret = InputCheckUtil.checkHalfSize((String)value);
        } else if (type.equals(DIGIT)) {
            ret = InputCheckUtil.checkDigit((String)value);
        } else if (type.equals(EISU)) {
            ret = InputCheckUtil.checkDigitAlphabet((String)value);
        } else if (type.equals(EIJI)) {
            ret = InputCheckUtil.checkAlphabet((String)value);
        } else if (type.equals(HANKAKU_KANA)) {
            ret = InputCheckUtil.checkHankakuKana((String)value);
        } else if (type.equals(DIGIT_LENGTH)) {
            ret = InputCheckUtil.checkDigitLength((String)value, (double)min, (double)max);
        } else if (type.equals(STR_LENGTH)) {
            ret = InputCheckUtil.checkStrLength((String)value, (int)((int)min), (int)((int)max));
        } else if (type.equals(REQUIRD)) {
            ret = InputCheckUtil.checkRequerd((String)value);
        } else if (type.equals(MAIL)) {
            ret = InputCheckUtil.checkMailAddr((String)value);
        } else if (type.equals(TEL)) {
            ret = InputCheckUtil.checkTelNo((String)value);
        } else if (type.equals(POST)) {
            ret = InputCheckUtil.checkPostCode((String)value);
        } else if (type.equals(URL)) {
            ret = InputCheckUtil.checkUrl((String)value);
        } else {
            String errmsg = "Input Check Type Error [" + type + "]";
            this.putMessage(errList, msgkey, errmsg);
        }
        if (!ret) {
            this.putMessage(errList, msgkey, msgbody);
        }
    }

    protected void putMessage(HashMap errList, Object key, Object msg) {
        if (key != null) {
            this.putMessage(errList, key);
        } else {
            errList.put(msg, msg);
        }
    }

    protected void putMessage(HashMap errList, Object key) {
        MessageMappings messages = MessageMappings.getInstance();
        String message = (String)messages.get(key);
        errList.put(key, message);
    }
}

