/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.el;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.itscool.commons.bean.BeanUtil;
import org.itscool.commons.bean.BeanUtilRuntimeException;
import org.itscool.commons.logging.AbstractLog;
import org.itscool.commons.logging.SimpleLog;
import org.itscool.stylist.el.ElRegexException;
import org.itscool.stylist.el.ElementFunc;
import org.itscool.stylist.el.ElementList;

public class BaseElRegex {
    protected AbstractLog log = SimpleLog.getInstance();
    public static final String DEFAULT_PKG = "org.itscool.stylist.function";
    private String orgPkg = "org.itscool.stylist.function";

    public String replaceFunction(String orgPkg, String srcStr) {
        if (srcStr == null) {
            return "";
        }
        this.orgPkg = orgPkg;
        Pattern pattern = Pattern.compile("\\$\\{\\s*[A-Za-z_0-9|(|\\)]*\\.[A-Za-z_0-9|(|\\)]*\\b\\(([A-Za-z_0-9|\\s|\\+|\\-|\"|\\'|/|:|.|,|\\(|\\)\\s]*)\\s*\\)\\s*}");
        Matcher matcher = pattern.matcher(srcStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String el = matcher.group();
            String value = this.parseFunction(el = el.trim());
            if (value == null) {
                value = "";
            }
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String parseFunction(String srcStr) {
        Pattern pattern = Pattern.compile("\\s*[A-Za-z_0-9|(|\\)]*\\.[A-Za-z_0-9|(|\\)]*\\b\\(([A-Za-z_0-9|\\s|\\+|\\-|\"|\\'|/|:|.|,|\\(|\\)\\s]*)\\s*\\)\\s*");
        Matcher matcher = pattern.matcher(srcStr);
        if (matcher.find()) {
            String functionStr = matcher.group();
            functionStr = functionStr.trim();
            ElementFunc func = ElementFunc.createFuncList(functionStr);
            String result = this.getFunctionResult(func);
            return result;
        }
        return "";
    }

    public String replaceEl(String srcStr) {
        if (srcStr == null) {
            return "";
        }
        Pattern pattern = Pattern.compile("\\$\\{\\s*\\b([A-Za-z_0-9|.|\\(|\\)]*)\\s*\\}");
        Matcher matcher = pattern.matcher(srcStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String el = matcher.group();
            Object value = this.parseObj(el);
            if (value == null) {
                value = "";
            }
            matcher.appendReplacement(sb, value.toString());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public Object parseObj(String dstStr) {
        StringBuffer sb2 = new StringBuffer();
        Pattern pattern2 = Pattern.compile("\\s*\\b([A-Za-z_0-9|.]*)\\s*");
        Matcher matcher2 = pattern2.matcher(dstStr);
        if (!matcher2.find()) {
            return null;
        }
        String tag = matcher2.group();
        ElementList elems = ElementList.createElementList(tag);
        Object attr = this.getAttribute(elems);
        return attr;
    }

    public StringBuffer parsePath(String dstStr, String replace) {
        StringBuffer criteria = new StringBuffer();
        criteria.append("<a.*href\\s*=\\s*\".*\"");
        criteria.append("|<img.*src\\s*=\\s*\".*\"");
        criteria.append("|<link.*src\\s*=\\s*\".*\"");
        criteria.append("|<link.*href\\s*=\\s*\".*\"");
        criteria.append("|<script.*src\\s*=\\s*\".*\"");
        criteria.append("|<.*background\\s*=\\s*\".*\"");
        criteria.append("|<form.*action\\s*=\\s*\".*\"");
        Pattern pattern = Pattern.compile(criteria.toString());
        Matcher matcher = pattern.matcher(dstStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            StringBuffer sb2 = new StringBuffer();
            String element = matcher.group();
            boolean flg = false;
            Pattern pattern2 = Pattern.compile("\"\\./");
            Matcher matcher2 = pattern2.matcher(element);
            while (matcher2.find()) {
                String path = matcher2.group();
                matcher2.appendReplacement(sb2, replace);
                flg = true;
            }
            matcher2.appendTail(sb2);
            String tag = sb2.toString();
            if (flg) {
                tag = BaseElRegex.supressPath(tag);
            }
            matcher.appendReplacement(sb, tag);
        }
        matcher.appendTail(sb);
        return sb;
    }

    public static String supressPath(String tag) {
        Pattern pattern = Pattern.compile("\\.\\./");
        Matcher matcher = pattern.matcher(tag);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected Object getAttribute(ElementList elems) {
        return elems.getTagString();
    }

    protected String getFunctionResult(ElementFunc func) {
        String funcName = func.getFuncName();
        String clazz = func.getClassName();
        String clazzName = this.orgPkg + "." + clazz;
        try {
            clazzName = "org.itscool.stylist.function." + clazz;
            Class.forName(clazzName);
        }
        catch (Exception e) {
            clazzName = this.orgPkg + "." + clazz;
        }
        catch (Error e) {
            clazzName = this.orgPkg + "." + clazz;
        }
        try {
            Class.forName(clazzName);
        }
        catch (ClassNotFoundException e) {
            throw new ElRegexException("No Function Class = " + clazzName + " Func = " + funcName);
        }
        catch (Error e) {
            throw new ElRegexException("No Function Class = " + clazzName + " Func = " + funcName);
        }
        Object[] argList = this.convertArgument(func);
        try {
            Object result = BeanUtil.invoke((String)clazzName, (String)funcName, (Object[])argList);
            if (result != null) {
                return result.toString();
            }
            return "";
        }
        catch (BeanUtilRuntimeException e) {
            String msg = e.getMessage() + "arg num=" + argList.length + "args = " + this.toStringArgList(argList);
            this.log.trace(msg);
            throw new ElRegexException(msg);
        }
    }

    protected String toStringArgList(Object[] argList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < argList.length; ++i) {
            String type = "null";
            String data = "null";
            if (argList[i] != null) {
                type = argList[i].getClass().getName();
                data = argList[i].toString();
            }
            sb.append("[").append(type).append("]");
            sb.append(data);
            if (i >= argList.length) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected Object[] convertArgument(ElementFunc func) {
        LinkedList srcArgList = func.getArgList();
        int size = srcArgList.size();
        LinkedList<Object> dstArgList = new LinkedList<Object>();
        for (int i = 0; i < size; ++i) {
            ElementList elementList = (ElementList)srcArgList.get(i);
            Object arg = this.getAttribute(elementList);
            if (arg == null) {
                dstArgList.add(null);
                continue;
            }
            if (arg instanceof String) {
                String argStr = arg.toString();
                int strToken1 = argStr.trim().indexOf("'");
                int strToken2 = argStr.trim().lastIndexOf("'");
                if (strToken1 == 0 && strToken2 == argStr.length() - 1) {
                    arg = BeanUtil.supressQuate((String)argStr);
                }
            }
            dstArgList.add(arg);
        }
        return dstArgList.toArray();
    }
}

