/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.stylist.tag;

import java.util.ArrayList;
import java.util.LinkedList;
import org.itscool.stylist.tag.HtmlAttribute;

public class HtmlTag
extends LinkedList {
    public static final String TEXT = "#text";
    public static final String COMMENT = "#comment";
    public static final String TAG_TEXTAREA = "textarea";
    public static final String TAG_SELECT = "select";
    public static final String TAG_HTML = "html";
    public static final String TAG_HEAD = "head";
    public static final String TAG_TITLE = "title";
    public static final String TAG_SCRIPT = "script";
    public static final String TAG_STYLE = "style";
    public static final String TAG_BODY = "body";
    public static final String KIND_TAG = "tag";
    public static final String KIND_SIMPLE_TAG = "simple";
    public static final String KIND_COMMENT = "comment";
    public static final String KIND_TEXT = "text";
    public static final String KIND_ITERATE = "iterate";
    public static final String KIND_EQUAL = "equal";
    public static final String KIND_NOTEQUAL = "neq";
    public static final String KIND_MOREEQUAL = "meq";
    public static final String KIND_LESSEQUAL = "leq";
    public static final String KIND_MORETHAN = "mthan";
    public static final String KIND_LESSTHAN = "lthan";
    public static final String KIND_MATCH = "match";
    public static final String KIND_NOMATCH = "nmatch";
    public static final String KIND_ISNULL = "isnull";
    public static final String KIND_ISNOTNULL = "isnotnull";
    public static final String KIND_WRITE = "write";
    public static final String KIND_DISPLAY_ERROR = "error";
    public static final String KIND_INCLUDE = "include";
    public static final String KIND_CDATA = "cdata";
    protected HtmlTag parent;
    protected ArrayList attributeList = new ArrayList();
    protected String tagName;
    protected String tagKind;

    public String toString(int floor, String tab) {
        String line = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(floor + " : ");
        if (this.tagKind.equals(KIND_TAG)) {
            sb.append("[B_TAG]   |");
        } else if (this.tagKind.equals(KIND_SIMPLE_TAG)) {
            sb.append("[S_TAG]   |");
        } else if (this.tagKind.equals(KIND_COMMENT)) {
            sb.append("[COMMENT] |");
        } else if (this.tagKind.equals(KIND_ITERATE)) {
            sb.append("[ITERATE] |");
        } else if (this.tagKind.equals(KIND_EQUAL)) {
            sb.append("[EQUAL]   |");
        } else if (this.tagKind.equals(KIND_MOREEQUAL)) {
            sb.append("[MORE_EQ] |");
        } else if (this.tagKind.equals(KIND_LESSEQUAL)) {
            sb.append("[LESS_EQ] |");
        } else if (this.tagKind.equals(KIND_MORETHAN)) {
            sb.append("[M_THAN]  |");
        } else if (this.tagKind.equals(KIND_LESSTHAN)) {
            sb.append("[L_THAN]  |");
        } else if (this.tagKind.equals(KIND_ISNULL)) {
            sb.append("[ISNULL]  |");
        } else if (this.tagKind.equals(KIND_ISNOTNULL)) {
            sb.append("[ISNOTNULL]|");
        } else if (this.tagKind.equals(KIND_TEXT)) {
            sb.append("[TEXT]    |");
        } else if (this.tagKind.equals(KIND_WRITE)) {
            sb.append("[WRITE]   |");
        } else if (this.tagKind.equals(KIND_DISPLAY_ERROR)) {
            sb.append("[ERROR]   |");
        } else if (this.tagKind.equals(KIND_INCLUDE)) {
            sb.append("[INCLUDE] |");
        } else if (this.tagKind.equals(KIND_CDATA)) {
            sb.append("[CDATA]   |");
        } else {
            sb.append("[FAITAL]  |");
        }
        sb.append(tab).append(this.tagName);
        int attrSize = this.attributeList.size();
        if (attrSize > 0) {
            sb.append(" ( ");
        }
        for (int i = 0; i < attrSize; ++i) {
            HtmlAttribute attr = (HtmlAttribute)this.attributeList.get(i);
            sb.append(attr.getName());
            sb.append("=");
            sb.append(attr.getValue());
            sb.append(" ");
        }
        if (attrSize > 0) {
            sb.append(")");
        }
        sb.append(line);
        int nodeSize = this.size();
        for (int i = 0; i < nodeSize; ++i) {
            HtmlTag child = (HtmlTag)this.get(i);
            sb.append(child.toString(floor + 1, tab + "  "));
        }
        return sb.toString();
    }

    public void addHtmlNode(HtmlTag node) {
        this.add(node);
    }

    public void addAttribute(HtmlAttribute attr) {
        this.attributeList.add(attr);
    }

    public ArrayList getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(ArrayList attributeList) {
        this.attributeList = attributeList;
    }

    public String getTagKind() {
        return this.tagKind;
    }

    public void setTagKind(String tagKind) {
        this.tagKind = tagKind;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getAttribute(String name) {
        int size = this.attributeList.size();
        for (int i = 0; i < size; ++i) {
            HtmlAttribute attr = (HtmlAttribute)this.attributeList.get(i);
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public HtmlAttribute getHtmlAttribute(String name) {
        int size = this.attributeList.size();
        for (int i = 0; i < size; ++i) {
            HtmlAttribute attr = (HtmlAttribute)this.attributeList.get(i);
            if (!attr.getName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public HtmlTag getParent() {
        return this.parent;
    }

    public void setParent(HtmlTag parent) {
        this.parent = parent;
    }
}

