/*
 * Decompiled with CFR 0.152.
 */
package org.itscool.commons.document;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.itscool.commons.document.AbstractDocument;
import org.itscool.commons.document.DocumentBean;

public class DocumentBeanParser {
    public static DocumentBean parseBean(Object bean, Class clazz, AbstractDocument document) throws IllegalAccessException, InvocationTargetException {
        DocumentBean pBean = new DocumentBean();
        String clazzTagName = document.isReplaceClassToTagName(clazz.getName());
        if (clazzTagName == null) {
            clazzTagName = clazz.getName();
            int index = clazzTagName.lastIndexOf(".");
            clazzTagName = clazzTagName.substring(index + 1, clazzTagName.length());
        }
        pBean.setName(clazzTagName);
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            DocumentBean newBean;
            Object property;
            Method method = methods[i];
            String getterName = method.getName();
            if (getterName.indexOf("get") != 0 && getterName.indexOf("is") != 0 || getterName.indexOf("getClass") == 0) continue;
            Class<?> propertyType = method.getReturnType();
            if (propertyType.isArray()) {
                Object[] collection = (Object[])method.invoke(bean, null);
                Iterator<Object> iterator = Arrays.asList(collection).iterator();
                property = iterator;
            } else {
                property = method.invoke(bean, null);
            }
            int firstMemberIndex = 3;
            if (getterName.indexOf("is") == 0) {
                firstMemberIndex = 2;
            }
            String memberName = getterName.substring(firstMemberIndex, getterName.length());
            memberName = memberName.substring(0, 1).toLowerCase() + memberName.substring(1, memberName.length());
            String tagName = document.isReplaceMemberToTagName(clazz.getName(), memberName);
            if (property instanceof Collection || property instanceof Iterator) {
                Object iterator = property instanceof Collection ? ((Collection)property).iterator() : property;
                newBean = new DocumentBean();
                if (tagName != null) {
                    newBean.setName(tagName);
                } else {
                    newBean.setName(memberName);
                }
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (object == null) continue;
                    DocumentBean childBean = DocumentBeanParser.parseBean(object, object.getClass(), document);
                    newBean.add(childBean);
                }
                pBean.add(newBean);
                continue;
            }
            if (property instanceof Map) {
                Map map = (Map)property;
                newBean = new DocumentBean();
                if (tagName != null) {
                    newBean.setName(tagName);
                } else {
                    newBean.setName(memberName);
                }
                Set keySet = map.keySet();
                Iterator iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next();
                    Object object = map.get(key);
                    if (object == null) continue;
                    DocumentBean childBean = DocumentBeanParser.parseBean(object, object.getClass(), document);
                    newBean.add(childBean);
                }
                pBean.add(newBean);
                continue;
            }
            if (!(propertyType == null || propertyType.isPrimitive() || propertyType.getName().equals("java.util.Date") || propertyType.getName().equals("java.lang.String"))) {
                if (property == null) continue;
                DocumentBean childBean = DocumentBeanParser.parseBean(property, propertyType, document);
                if (tagName != null) {
                    childBean.setName(tagName);
                } else {
                    childBean.setName(memberName);
                }
                pBean.add(childBean);
                continue;
            }
            DocumentBean newBean2 = new DocumentBean();
            if (tagName != null) {
                newBean2.setName(tagName);
            } else {
                newBean2.setName(memberName);
            }
            if (property == null) {
                property = "";
            }
            newBean2.setValue(property.toString());
            pBean.add(newBean2);
        }
        return pBean;
    }
}

