// gyazowin.cpp : AvP[ṼGg |Cg`܂B
//

// Written by tnj ( http://nothing.sh/blog/archives/44 )
// Recreated by NV ( http://d.hatena.ne.jp/nvsofts/20090321/1237619040 ), Keiya Chinen
// LICENSE: Creative Commons Attribution-Noncommercial 2.1 Japan License

#include "stdafx.h"
#include "gyazowin.h"

// O[oϐ:
HINSTANCE hInst;							// ݂̃C^[tFCX
TCHAR *szTitle			= _T("gyazowin");	// ^Cg o[̃eLXg
TCHAR *szWindowClass	= _T("GYAZOWIN");	// C EBhE NX

int ofX, ofY;	// ʃItZbg
std::map<std::wstring, std::wstring> g_Settings;

// vg^Cv錾
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);

int					GetEncoderClsid(const WCHAR* format, CLSID* pClsid);

BOOL				desktopCap(HWND hWnd);
BOOL				savePNG(LPCTSTR fileName, HBITMAP newBMP);
BOOL				uploadFile(HWND hwnd, LPCTSTR fileName);

std::map<std::wstring, std::wstring> loadSettings(LPCWSTR fileName, LPCWSTR sectionName);

// Gg[|Cg
int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	MSG msg;

	TCHAR	szThisPath[MAX_PATH];
	DWORD   sLen;

	// g̃fBNg擾
	sLen = GetModuleFileName(NULL, szThisPath, MAX_PATH);
	for(unsigned int i = sLen; i >= 0; i--) {
		if(szThisPath[i] == _T('\\')) {
			szThisPath[i] = _T('\0');
			break;
		}
	}

	// JgfBNg exe Ɠꏊɐݒ
	SetCurrentDirectory(szThisPath);

	g_Settings = loadSettings(_T("deskwatcher.ini"), _T("gyazowin+"));

	desktopCap(NULL);

	// EBhENXo^
	MyRegisterClass(hInstance);

	// AvP[V̏s܂:
	if (!InitInstance (hInstance, nCmdShow))
	{
		return FALSE;
	}
	
	// C bZ[W [v:
	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return (int) msg.wParam;
}

// ݒ[h
std::map<std::wstring, std::wstring> loadSettings(LPCWSTR fileName, LPCWSTR sectionName)
{
	std::map<std::wstring, std::wstring> settings;
	TCHAR wcFilePath[MAX_PATH];
	TCHAR wcSettings[32767];
	TCHAR *lpwcCurrent;
	TCHAR *lpwcString;
	TCHAR *lpwcContext;
	size_t len;
	std::wstring key;
	std::wstring value;

	GetFullPathName(fileName, MAX_PATH, wcFilePath, NULL);
	GetPrivateProfileSection(sectionName, wcSettings, 32767, wcFilePath);

	lpwcCurrent = wcSettings;
	while (*lpwcCurrent) {
		len = wcslen(lpwcCurrent);
		lpwcString = wcstok_s(lpwcCurrent, _T("="), &lpwcContext);
		key = std::wstring(lpwcString);
		value = std::wstring(lpwcString + wcslen(lpwcString) + 1);
		settings[key] = value;
		lpwcCurrent += len + 1;
	}

	return settings;
}

// EBhENXo^
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASS wc;

	wc.style         = 0;							// WM_PAINT 𑗂Ȃ
	wc.lpfnWndProc   = WndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = hInstance;
	wc.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_GYAZOWIN));
	wc.hCursor       = LoadCursor(NULL, IDC_CROSS);	// + ̃J[\
	wc.hbrBackground = 0;							// wiݒ肵Ȃ
	wc.lpszMenuName  = 0;
	wc.lpszClassName = szWindowClass;

	return RegisterClass(&wc);
}


// CX^X̏iSʂEBhEŕj
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
	HWND hWnd;
	hInst = hInstance; // O[oϐɃCX^Xi[܂B

	int x, y, w, h;

	// zXN[ŜJo[
	x = GetSystemMetrics(SM_XVIRTUALSCREEN);
	y = GetSystemMetrics(SM_YVIRTUALSCREEN);
	w = GetSystemMetrics(SM_CXVIRTUALSCREEN);
	h = GetSystemMetrics(SM_CYVIRTUALSCREEN);

	// x, y ̃ItZbgloĂ
	ofX = x; ofY = y;

	// Sɓ߂EBhE
	hWnd = CreateWindowEx(
		WS_EX_TRANSPARENT | WS_EX_TOOLWINDOW | WS_EX_TOPMOST
#if(_WIN32_WINNT >= 0x0500)
		| WS_EX_NOACTIVATE
#endif
		,
		szWindowClass, NULL, WS_POPUP,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
		NULL, NULL, hInstance, NULL);

	// Ȃ...?
	if (!hWnd) return FALSE;
	
	// Sʂ𕢂
	MoveWindow(hWnd, x, y, w, h, FALSE);
	
	// nCmdShow 𖳎 (SW_MAXIMIZE Ƃƍ)
	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);
	
	return TRUE;
}

// w肳ꂽtH[}bgɑΉ Encoder  CLSID 擾
// Cited from MSDN Library: Retrieving the Class Identifier for an Encoder
int GetEncoderClsid(const WCHAR* format, CLSID* pClsid)
{
   UINT  num = 0;          // number of image encoders
   UINT  size = 0;         // size of the image encoder array in bytes

   ImageCodecInfo* pImageCodecInfo = NULL;

   GetImageEncodersSize(&num, &size);
   if(size == 0)
      return -1;  // Failure

   pImageCodecInfo = (ImageCodecInfo*)(malloc(size));
   if(pImageCodecInfo == NULL)
      return -1;  // Failure

   GetImageEncoders(num, size, pImageCodecInfo);

   for(UINT j = 0; j < num; ++j)
   {
      if( wcscmp(pImageCodecInfo[j].MimeType, format) == 0 )
      {
         *pClsid = pImageCodecInfo[j].Clsid;
         free(pImageCodecInfo);
         return j;  // Success
      }    
   }

   free(pImageCodecInfo);
   return -1;  // Failure
}

// PNG `ŕۑ (GDI+ gp)
BOOL savePNG(LPCTSTR fileName, HBITMAP newBMP)
{
	BOOL				res = FALSE;

	GdiplusStartupInput	gdiplusStartupInput;
	ULONG_PTR			gdiplusToken;
	CLSID				clsidEncoder;

	// GDI+ ̏
	GdiplusStartup(&gdiplusToken, &gdiplusStartupInput, NULL);
	
	// HBITMAP  Bitmap 쐬
	Bitmap *b = new Bitmap(newBMP, NULL);
	
	if (GetEncoderClsid(L"image/png", &clsidEncoder)) {
		// save!
		if (0 ==
			b->Save(fileName, &clsidEncoder, 0) ) {
				// ۑł
				res = TRUE;
		}
	}
	
	// n
	delete b;
	GdiplusShutdown(gdiplusToken);

	return res;
}

// EBhEvV[W
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{

		case WM_DESTROY:
			{
			PostQuitMessage(0);
			break;
			}
	
		default:
			DefWindowProc(hWnd, message, wParam, lParam);
	}
		return 0;
}

// PNG t@CAbv[h.
BOOL uploadFile(HWND hwnd, LPCTSTR fileName)
{
	const char*  sBoundary = "----BOUNDARYBOUNDARY----";		// boundary
	const char   sCrLf[]   = { 0xd, 0xa, 0x0 };					// s(CR+LF)
	const TCHAR* szHeader  = 
		_T("Content-type: multipart/form-data; boundary=----BOUNDARYBOUNDARY----");

	std::ostringstream	buf;	// MbZ[W

	LPCWSTR lpwcUploadServer;	// Abv[hT[o
	LPCWSTR lpwcUploadPath;		// Abv[hpX

	LPCWSTR lpwcId;			// FؗpID
	LPCWSTR lpwcPassword;	// FؗppX[h

	DWORD dwFlags;	// tO

	buf << "--";
	buf << sBoundary;
	buf << sCrLf;
	buf << "content-disposition: form-data; name=\"imagedata\"; filename=\"data.png\"";
	buf << sCrLf;
	buf << "Content-type: image/png";	// ꉞ
	buf << sCrLf;
	buf << sCrLf;

	// {: PNG t@Cǂݍ
	std::ifstream png;
	png.open(fileName, std::ios::binary);
	if (png.fail()) {
		MessageBox(hwnd, _T("png open failed"), _T("ERROR"), MB_ICONERROR | MB_OK);
		png.close();
		return FALSE;
	}
	buf << png.rdbuf();		// read all & append to buffer
	png.close();

	// Ō
	buf << sCrLf;
	buf << "--";
	buf << sBoundary;
	buf << "--";
	buf << sCrLf;

	// bZ[W
	std::string oMsg(buf.str());

	// Abv[h
	if (g_Settings.count(L"upload_server")) {
		lpwcUploadServer = g_Settings[L"upload_server"].c_str();
	}else{
		return FALSE;
	}
	if (g_Settings.count(L"upload_path")) {
		lpwcUploadPath = g_Settings[L"upload_path"].c_str();
	}else{
		return FALSE;
	}

	// F؃f[^
	if (g_Settings.count(L"use_auth") && g_Settings[L"use_auth"] == L"yes") {
		if (g_Settings.count(L"auth_id")) {
			lpwcId = g_Settings[L"auth_id"].c_str();
		}else{
			lpwcId = L"";
		}
		if (g_Settings.count(L"auth_pw")) {
			lpwcPassword = g_Settings[L"auth_pw"].c_str();
		}else{
			lpwcPassword = L"";
		}
	}else{
		lpwcId = NULL;
		lpwcPassword = NULL;
	}

	// WinInet  (proxy  K̐ݒ𗘗p)
	HINTERNET hSession    = InternetOpen(szTitle, 
		INTERNET_OPEN_TYPE_PRECONFIG, NULL, NULL, 0);
	if(NULL == hSession) {
		MessageBox(hwnd, _T("cannot configure wininet"),
			_T("Error"), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	// SSL
	dwFlags = INTERNET_FLAG_DONT_CACHE | INTERNET_FLAG_RELOAD;
	if (g_Settings.count(L"use_ssl") && g_Settings[L"use_ssl"] == L"yes") {
		dwFlags |= INTERNET_FLAG_SECURE;
		if (g_Settings.count(L"ssl_check_cert") && g_Settings[L"ssl_check_cert"] == L"no") {
			dwFlags |= INTERNET_FLAG_IGNORE_CERT_CN_INVALID | INTERNET_FLAG_IGNORE_CERT_DATE_INVALID;
		}
	}

	// ڑ
	HINTERNET hConnection = InternetConnect(hSession, 
		lpwcUploadServer, INTERNET_DEFAULT_HTTP_PORT,
		lpwcId, lpwcPassword, INTERNET_SERVICE_HTTP, 0, NULL);
	if(NULL == hSession) {
		MessageBox(hwnd, _T("cannot initiate connection"),
			_T("Error"), MB_ICONERROR | MB_OK);
		return FALSE;
	}

	// v̐ݒ
	HINTERNET hRequest    = HttpOpenRequest(hConnection,
		_T("POST"), lpwcUploadPath, NULL,
		NULL, NULL, dwFlags, NULL);
	if(NULL == hSession) {
		MessageBox(hwnd, _T("cannot compose post request"),
			_T("Error"), MB_ICONERROR | MB_OK);
		return FALSE;
	}
	
	// v𑗐M
	if (HttpSendRequest(hRequest,
                    szHeader,
					lstrlen(szHeader),
                    (LPVOID)oMsg.c_str(),
					(DWORD) oMsg.length()))
	{
		// v͐
		
		DWORD resLen = 8;
		TCHAR resCode[8];

		// status code 擾
		HttpQueryInfo(hRequest, HTTP_QUERY_STATUS_CODE, resCode, &resLen, 0);
		if( _ttoi(resCode) != 200 ) {
			// upload s (status error)
			MessageBox(hwnd, _T("failed to upload (unexpected result code, under maintainance?)"),
				_T("Error"), MB_ICONERROR | MB_OK);
		} else {
			return TRUE;
		}
	} else {
		// Abv[hs...
		MessageBox(hwnd, _T("failed to upload"), _T("Error"), MB_ICONERROR | MB_OK);
	}

	return FALSE;

}

BOOL desktopCap(HWND hWnd)
{
	// ʂɒڕ`CČ`
	HDC hdc = GetDC(NULL);
	
	int iWidth, iHeight;
	iWidth  = GetSystemMetrics(SM_CXSCREEN); 
	iHeight = GetSystemMetrics(SM_CYSCREEN);
	
	// rbg}bvobt@쐬
	HBITMAP newBMP = CreateCompatibleBitmap(hdc, iWidth, iHeight);
	HDC	    newDC  = CreateCompatibleDC(hdc);
	
	// ֘AÂ
	SelectObject(newDC, newBMP);
	
	// 摜擾
	BitBlt(newDC, 0, 0, iWidth, iHeight, 
	hdc, 0, 0, SRCCOPY);

	// EBhEB!
	ShowWindow(hWnd, SW_HIDE);

	// e|t@C
	TCHAR tmpDir[MAX_PATH], tmpFile[MAX_PATH];
	GetTempPath(MAX_PATH, tmpDir);
	GetTempFileName(tmpDir, _T("gya"), 0, tmpFile);
	
	if (savePNG(tmpFile, newBMP)) {
	
		// 
		if (!uploadFile(hWnd, tmpFile)) {

		}
	} else {
		// PNGۑs...
		MessageBox(hWnd, _T("cannot save png image"), _T("ERROR"), 
			MB_OK | MB_ICONERROR);
	}

	// n
	DeleteFile(tmpFile);

	DeleteDC(newDC);
	DeleteObject(newBMP);

	ReleaseDC(NULL, hdc);
	DestroyWindow(hWnd);
	return 0;
}