#!/bin/sh
#
# init script for JBoss
#

#
# Copyright 2006 Yomei Komiya
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# 	http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# Default settings
#  - Java home:                  /usr/lib/j2sdk1.5-sun
#  - JBoss home:                 /usr/local/jboss
#  - JBoss run user:             jboss
#  - JBoss server configuration: default
#  - JBoss run options:          none
#  - JBoss shutdown options:     none
#  - JBoss cosole log output:    /dev/null
#
# e.g.)
#  1. Create Run User
#   # adduser --shell /bin/sh --uid 10000 --disabled-password --disabled-login jboss
#  2. Add Daemon (Debian)
#   # update-rc.d jboss defaults 80 20
#  3. Delete Daemon (Debian)
#   # update-rc.d -f jboss remove
#
# JBoss run usage: run.sh [options]
#
#  options:
#    --                            Stop processing options
#    -D<name>[=<value>]            Set a system property
#    -d, --bootdir=<dir>           Set the boot patch directory; Must be absolute or url
#    -p, --patchdir=<dir>          Set the patch directory; Must be absolute or url
#    -n, --netboot=<url>           Boot from net with the given url as base
#    -c, --configuration=<name>    Set the server configuration name
#    -B, --bootlib=<filename>      Add an extra library to the front bootclasspath
#    -L, --library=<filename>      Add an extra library to the loaders classpath
#    -C, --classpath=<url>         Add an extra url to the loaders classpath
#    -P, --properties=<url>        Load system properties from the given url
#    -b, --host=<host or ip>       Bind address for all JBoss services
#    -g, --partition=<name>        HA Partition name (default=DefaultDomain)
#    -u, --udp=<ip>                UDP multicast address
#    -l, --log=<log4j|jdk>         Specify the logger plugin type
#
# JBoss shutdown usage: shutdown.sh [options] <operation>
#
#  options:
#    -h, --help                Show this help message (default)
#    -D<name>[=<value>]        Set a system property
#    --                        Stop processing options
#    -s, --server=<url>        Specify the JNDI URL of the remote server
#    -n, --serverName=<url>    Specify the JMX name of the ServerImpl
#    -a, --adapter=<name>      Specify JNDI name of the MBeanServerConnection to use
#    -u, --user=<name>         Specify the username for authentication
#    -p, --password=<name>     Specify the password for authentication
#
#  operations:
#    -S, --shutdown            Shutdown the server
#    -e, --exit=<code>         Force the VM to exit with a status code
#    -H, --halt=<code>         Force the VM to halt with a status code
#
# $Id$
#

DESC="J2EE application server"
NAME="JBoss"

## Settings ####################################################################

JAVA_HOME=${JAVA_HOME:-"/usr/lib/j2sdk1.5-sun"}
#JAVA_HOME=${JAVA_HOME:-"/usr/lib/jvm/java-1.5.0-sun"}
JAVA_PATH=${JAVA_PATH:-"$JAVA_HOME/bin"}

JBOSS_HOME=${JBOSS_HOME:-"/usr/local/jboss"}
JBOSS_USER=${JBOSS_USER:-"jboss"}

# define the JBoss server configuration
JBOSS_CONF=${JBOSS_CONF:-"default"}
JBOSS_RUN_OPTS=${JBOSS_RUN_OPTS:-""}
#JBOSS_RUN_OPTS=${JBOSS_RUN_OPTS:-"--host=127.0.0.1 -Djava.security.egd=file:/dev/urandom"}
JBOSS_SHUTDOWN_OPTS=${JBOSS_SHUTDOWN_OPTS:-""}
#JBOSS_SHUTDOWN_OPTS=${JBOSS_SHUTDOWN_OPTS:-"--server=127.0.0.1:1199"}

#JBOSS_CONSOLE=${JBOSS_CONSOLE:-"$JBOSS_HOME/server/$JBOSS_CONF/log/console.log"}

################################################################################

#define what will be done with the console log
if [ -n "$JBOSS_CONSOLE" -a ! -d "$JBOSS_CONSOLE" ]; then
	touch $JBOSS_CONSOLE
fi

if [ -n "$JBOSS_CONSOLE" -a ! -f "$JBOSS_CONSOLE" ]; then
	echo "[WARNING]: location for saving console log invalid: $JBOSS_CONSOLE"
	echo "[WARNING]: ignoring it and using /dev/null"
	JBOSS_CONSOLE="/dev/null"
fi

JBOSS_CONSOLE=${JBOSS_CONSOLE:-"/dev/null"}

CMD_START="$JBOSS_HOME/bin/run.sh -c $JBOSS_CONF $JBOSS_RUN_OPTS"

CMD_STOP="$JBOSS_HOME/bin/shutdown.sh $JBOSS_SHUTDOWN_OPTS --shutdown"
#define the classpath for the shutdown class
#JBOSS_CLASSPATH=${JBOSS_CLASSPATH:-"$JBOSS_HOME/bin/shutdown.jar:$JBOSS_HOME/client/jnet.jar"}
#CMD_STOP="java -classpath $JBOSS_CLASSPATH org.jboss.Shutdown --shutdown"

SUBIT="su - $JBOSS_USER -c "

if [ -z "`echo $PATH | grep $JAVA_PATH`" ]; then
	export PATH=$PATH:$JAVA_PATH
fi

if [ ! -d "$JBOSS_HOME" ]; then
	echo "[ERROR] JBOSS_HOME does not exist as a valid directory : $JBOSS_HOME"
	exit 1
fi

echo "JBoss Bootstrap Environment"
echo "  Java Home:            $JAVA_HOME"
echo "  JBoss Home:           $JBOSS_HOME"
echo "  JBoss User:           $JBOSS_USER"
echo "  Server Configuration: $JBOSS_CONF"
echo "  Run Options:          $JBOSS_RUN_OPTS"
echo "  Shutdown Options:     $JBOSS_SHUTDOWN_OPTS"
echo "  Console log:          $JBOSS_CONSOLE"

check_started() {
	if [ -z "`ps U ${JBOSS_USER} | grep org.jboss.Main | grep ${JBOSS_CONF}`" ]; then
		return 1	# not started.
	else
		return 0	# started.
	fi
}

start() {
	if ! check_started; then
		cd $JBOSS_HOME/bin
		if [ -z "$SUBIT" ]; then
			eval $CMD_START >${JBOSS_CONSOLE} 2>&1 &
		else
			$SUBIT "$CMD_START >${JBOSS_CONSOLE} 2>&1 &" 
		fi
		echo "Starting ${DESC}: ${NAME} ..."
		sleep 20
		echo "Server startup may take a while - check log files for completion"
	else
    	echo "Starting ${DESC}: [WARNING] ${NAME} already running"
    	exit 1
	fi
}

stop() {
	if check_started; then
		if [ -z "$SUBIT" ]; then
			$CMD_STOP
		else
			$SUBIT "$CMD_STOP"
		fi 
		echo "Stopping ${DESC}: ${NAME}."
	else
    	echo "Stopping ${DESC}: [WARNING] ${NAME} not running"
    	exit 1
	fi
}

restart() {
	echo "Restarting ${DESC}: ${NAME}."
	stop
	echo "Please wait for server shutdown ..."
	sleep 10
#	su - $JBOSS_USER -c 'killall java'
	start
}

case "$1" in
	start)
		start
		;;
	stop)
		stop
		;;
	restart)
		restart
		;;
	*)
		echo "usage: $0 (start|stop|restart|help)"
esac
