/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.compass;

import java.util.Map;

import org.compass.core.Compass;
import org.compass.core.config.CompassConfiguration;

/**
 * CompassContext
 * Context Object for Compass framework
 *
 * @author Yomei Komiya
 * 
 * @deprecated Use jp.sourceforge.metasearch.compass.CompassContext
 *		of <a href="http://metasearch.sourceforge.jp/">MetaSearch project</a>
 * @version $Id$
 */
public class CompassContext {
	
	/**
	 * Compass Object
	 */
	private Compass compass = null;
	
	/**
	 * Sen Home Directory Path
	 * injected by Spring
	 */
	private String senHome = null;
	
	/**
	 * Compass Configuration Location from classpath
	 * injected by Spring
	 */
	private String configLocation = "";
	
	/**
	 * Search Provider
	 * injected by Spring
	 */
	private String provider = "";
	
	/**
	 * Search Provider URL
	 * injected by Spring
	 */
	private String providerUrl = "";

	/**
	 * URI Context Map 
	 * (key: entity class's alias, value: URI context path)
	 * injected by Spring
	 */
	private Map resourceContextMap = null;

	
	/**
	 * Default constructor
	 */
	public CompassContext() {
		super();
	}

	
	public void setConfigLocation(String configLocation) {
		this.configLocation = configLocation;
	}
	

	public String getSenHome() {
		return senHome;
	}


	public void setSenHome(String senHome) {
		this.senHome = senHome;
	}


	public String getProvider() {
		return provider;
	}


	public void setProvider(String provider) {
		this.provider = provider;
	}


	public String getProviderUrl() {
		return providerUrl;
	}


	public void setProviderUrl(String providerUrl) {
		this.providerUrl = providerUrl;
	}


	public Map getResourceContextMap() {
		return resourceContextMap;
	}


	public void setResourceContextMap(Map resourceContextMap) {
		this.resourceContextMap = resourceContextMap;
	}


	/**
	 * Get Compass object
	 * 
	 * @return Compass object
	 */
	public Compass getCompass() {
		if (this.compass == null) {
			if (this.senHome != null) {
				System.setProperty("sen.home", this.senHome);
			}
			
			CompassConfiguration config = new CompassConfiguration();
			config.configure(this.configLocation);

			this.compass = config.buildCompass();
		}
		
		return this.compass;
	}

	
	/**
	 * Set compass object (for unit test)
	 * 
	 * @param compass Compass object
	 */
	protected void setCompass(Compass compass) {
		this.compass = compass;
	}

	
}
