/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2006 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.example.main.scheduling;

import jp.sourceforge.webframe.example.main.dao.SysLogDao;
import jp.sourceforge.webframe.example.main.entity.SysLogBean;

import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.dao.DataAccessException;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.transaction.TransactionException;

/**
 * ExampleJob
 * Scheduling Job Example
 *
 * @author Yomei Komiya
 *
 * $Id$
 */
public class ExampleJob extends QuartzJobBean {

	/**
	 * log4j logger
	 */
	static Logger logger = Logger.getLogger(ExampleJob.class);
	
	/**
	 * SysLogDao object is injected by Spring
	 * ref. WEB-INF/spring/schedulingContext.xml
	 */
	private SysLogDao sysLogDao = null;


	public void setSysLogDao(SysLogDao sysLogDao) {
		this.sysLogDao = sysLogDao;
	}

	
	protected void executeInternal(JobExecutionContext context)
			throws JobExecutionException {
		
		try {
			String log = "ExampleJob.executeInternal() was called.";
			SysLogBean sysLog = new SysLogBean(log, "ExampleJob");
		
			logger.info(log);
			sysLogDao.insertLog(sysLog);
		}
		catch (DataAccessException dae) {
			dae.printStackTrace();
			logger.error(dae);
		}
		catch (TransactionException txe) {
			txe.printStackTrace();
			logger.error(txe);
		}
		finally {
		}
	}

}
