/* vim: set tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2007 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * 	http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.sourceforge.webframe.io;

import java.io.File;
import java.net.URL;

import org.easymock.EasyMock;

import jp.sourceforge.webframe.test.AbstractEasyMockTestCase;

/**
 * DefaultByLineFileScannerTest
 *
 * @author Yomei Komiya
 * @since 0.9.2
 *
 * @version $Id$
 */
public class DefaultByLineFileScannerTest extends AbstractEasyMockTestCase {
	
	private static final String SAMPLE_CSV_FILE = "/testdata/CsvSample.EUC-JP.csv";
	
	private DefaultByLineFileScanner fileScanner = null;
	
	private LineConsumer lineConsumerMock = null;

	
	protected void setUp() throws Exception {
		super.setUp();
		
		this.lineConsumerMock
			= (LineConsumer)this.mocksControl.createMock(LineConsumer.class);
		this.fileScanner = new DefaultByLineFileScanner(lineConsumerMock);
	}

	
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	
	/*
	 * 'jp.sourceforge.webframe.io.DefaultByLineFileScanner.scan(String, String)' test method
	 */
	public void testScanStringString() throws Exception {
		URL fileUrl = this.getClass().getResource(SAMPLE_CSV_FILE);
		String encoding = "EUC-JP";
		
		// 1. normal
		this.mocksControl.reset();
		this.lineConsumerMock.consume((FileLine)EasyMock.isA(FileLine.class));
		EasyMock.expectLastCall().times(5);
		this.mocksControl.replay();
		
		this.fileScanner.scan(fileUrl.getPath(), encoding);
		
		this.mocksControl.verify();
	}

	
	/*
	 * 'jp.sourceforge.webframe.io.DefaultByLineFileScanner.scan(File, String)' test method
	 */
	public void testScanFileString() throws Exception {
		URL fileUrl = this.getClass().getResource(SAMPLE_CSV_FILE);
		File file = new File(fileUrl.getPath());
		String encoding = "EUC-JP";
		
		// 1. normal
		this.mocksControl.reset();
		this.lineConsumerMock.consume((FileLine)EasyMock.isA(FileLine.class));
		EasyMock.expectLastCall().times(5);
		this.mocksControl.replay();
		
		this.fileScanner.scan(file, encoding);
		
		this.mocksControl.verify();
		
		// 2. Exceptional
		this.mocksControl.reset();
		this.lineConsumerMock.consume((FileLine)EasyMock.isA(FileLine.class));
		EasyMock.expectLastCall().times(3);
		this.lineConsumerMock.consume((FileLine)EasyMock.isA(FileLine.class));
		EasyMock.expectLastCall().andThrow(new ScanAbortException());
		this.mocksControl.replay();
		
		try {
			this.fileScanner.scan(file, encoding);
			fail("Scanning must be stopped.");
		}
		catch (ScanAbortException sae) {
			// success
		}
		
		this.mocksControl.verify();
	}

}
