/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.compass;

import java.util.ArrayList;
import java.util.Map;
import jp.sourceforge.webframe.compass.CompassContext;
import jp.sourceforge.webframe.compass.SearchFailedException;
import jp.sourceforge.webframe.compass.SearchResult;
import jp.sourceforge.webframe.compass.entity.Searchable;
import org.apache.oro.text.perl.Perl5Util;
import org.compass.core.CompassException;
import org.compass.core.CompassHits;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryBuilder;
import org.compass.core.CompassQueryFilter;
import org.compass.core.CompassQueryFilterBuilder;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.Property;
import org.compass.core.Resource;

public class IndexSearcher {
    private CompassContext context = null;
    private String roleFieldName = "role";

    public void setContext(CompassContext context) {
        this.context = context;
    }

    public final void setRoleFieldName(String roleFieldName) {
        this.roleFieldName = roleFieldName;
    }

    public SearchResult find(String query) throws Exception {
        return this.find(query, 10, 0);
    }

    public SearchResult find(String query, String[] roles) throws Exception {
        return this.find(query, 10, 0, roles);
    }

    public SearchResult find(String query, int num, int start) throws SearchFailedException {
        return this.find(query, null, num, start, null);
    }

    public SearchResult find(String query, String currentQuery, int num, int start) throws SearchFailedException {
        return this.find(query, currentQuery, num, start, null);
    }

    public SearchResult find(String query, int num, int start, String[] roles) throws SearchFailedException {
        return this.find(query, null, num, start, roles);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SearchResult find(String query, String currentQuery, int num, int start, String[] roles) throws SearchFailedException {
        SearchResult searchResult;
        CompassSession session;
        block9: {
            session = null;
            CompassTransaction tx = null;
            CompassHits hits = null;
            try {
                try {
                    long elapsedTime = System.currentTimeMillis();
                    session = this.context.getCompass().openSession();
                    tx = session.beginTransaction(CompassTransaction.TransactionIsolation.READ_ONLY_READ_COMMITTED);
                    CompassQueryBuilder queryBuilder = session.queryBuilder();
                    CompassQueryBuilder.CompassBooleanQueryBuilder mainBooleanQueryBuilder = queryBuilder.bool();
                    if (currentQuery != null && !currentQuery.equals("")) {
                        mainBooleanQueryBuilder.addMust(queryBuilder.queryString(currentQuery).toQuery());
                    }
                    mainBooleanQueryBuilder.addMust(queryBuilder.queryString(query).toQuery());
                    CompassQuery currentCompassQuery = null;
                    if (roles != null && roles.length != 0) {
                        CompassQueryFilterBuilder queryFilterBuilder = session.queryFilterBuilder();
                        CompassQueryFilter roleFilter = this.buildRoleFilter(queryBuilder, queryFilterBuilder, roles);
                        currentCompassQuery = mainBooleanQueryBuilder.toQuery().setFilter(roleFilter);
                    } else {
                        currentCompassQuery = mainBooleanQueryBuilder.toQuery();
                    }
                    hits = currentCompassQuery.hits();
                    SearchResult result = this.buildSearchResult(query, currentCompassQuery.toString(), num, start, hits);
                    elapsedTime = System.currentTimeMillis() - elapsedTime;
                    result.setSearchTime(elapsedTime);
                    tx.commit();
                    searchResult = result;
                    Object var16_17 = null;
                    if (hits == null) break block9;
                }
                catch (CompassException ce) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    ce.printStackTrace();
                    throw new SearchFailedException(ce);
                }
            }
            catch (Throwable throwable) {
                Object var16_18 = null;
                if (hits != null) {
                    hits.close();
                }
                if (session == null) throw throwable;
                session.close();
                throw throwable;
            }
            hits.close();
        }
        if (session == null) return searchResult;
        session.close();
        return searchResult;
    }

    protected CompassQueryFilter buildRoleFilter(CompassQueryBuilder queryBuilder, CompassQueryFilterBuilder queryFilterBuilder, String[] roles) {
        CompassQueryBuilder.CompassBooleanQueryBuilder roleBooleanQueryBuilder = queryBuilder.bool();
        int i = 0;
        int legth = roles.length;
        while (i < legth) {
            roleBooleanQueryBuilder.addShould(queryBuilder.term(this.roleFieldName, (Object)roles[i]));
            ++i;
        }
        CompassQueryFilter roleFilter = queryFilterBuilder.query(roleBooleanQueryBuilder.toQuery());
        return roleFilter;
    }

    protected SearchResult buildSearchResult(String query, String currentQuery, int num, int start, CompassHits hits) {
        Map resourceContextMap = this.context.getResourceContextMap();
        SearchResult result = new SearchResult();
        ArrayList<Searchable> list = new ArrayList<Searchable>();
        int i = start;
        int j = hits.getLength();
        while (i < j) {
            if (i >= start + num) break;
            Resource resource = hits.resource(i);
            Searchable data = (Searchable)hits.data(i);
            data.setResourceAlias(resource.getAlias());
            data.setResourceContext((String)resourceContextMap.get(resource.getAlias()));
            data.buildIdentifier();
            data.setProvider(resource.getProperty("provider").getStringValue());
            data.setProviderUrl(resource.getProperty("providerUrl").getStringValue());
            data.setType(this.buildTypesString(resource.getProperties("type")));
            data.setRights(resource.getProperty("rights").getStringValue());
            String content = data.getContent();
            if (content != null) {
                data.setSize(content.length());
            } else {
                data.setSize(0L);
            }
            data.setScore(hits.score(i));
            data.setFragment(hits.highlighter(i).fragment("all"));
            list.add(data);
            ++i;
        }
        result.setProvider(this.context.getProvider());
        result.setProviderUrl(this.context.getProviderUrl());
        result.setQuery(IndexSearcher.trimExtraOperator(query));
        result.setCurrentQuery(IndexSearcher.trimExtraOperator(currentQuery));
        result.setTotalNum(hits.getLength());
        result.setNum(num);
        result.setStart(start);
        result.setList(list);
        return result;
    }

    protected String buildTypesString(Property[] typeProps) {
        String types = "";
        int i = 0;
        int j = typeProps.length;
        while (i < j) {
            types = types.equals("") ? String.valueOf(types) + typeProps[i].getStringValue() : String.valueOf(types) + "," + typeProps[i].getStringValue();
            ++i;
        }
        return types;
    }

    protected static String trimExtraOperator(String query) {
        Perl5Util perl = new Perl5Util();
        boolean match = perl.match("/^\\+\\((.*)\\)$/", query);
        if (match) {
            return IndexSearcher.trimExtraOperator(perl.group(1));
        }
        return query;
    }
}

