/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.springframework.util;

import jp.sourceforge.webframe.springframework.util.NoSuchSingletonBeanException;
import jp.sourceforge.webframe.springframework.util.SpringBeanHolder;
import jp.sourceforge.webframe.springframework.util.SpringUtils;
import org.apache.commons.collections.BidiMap;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringContextHolder {
    private ConfigurableApplicationContext applicationContext = null;
    private SpringBeanHolder[] beanHolders = null;
    private BidiMap singletonNameObjectIdMap = null;

    public SpringContextHolder(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.beanHolders = SpringUtils.getSpringBeanHolders(applicationContext);
        this.singletonNameObjectIdMap = SpringUtils.getSpringBeanSingletonNameObjectIdMap(this.beanHolders);
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public BidiMap getSingletonNameObjectIdMap() {
        return this.singletonNameObjectIdMap;
    }

    public SpringBeanHolder[] getBeanHolders() {
        return this.beanHolders;
    }

    public SpringBeanHolder[] getBeanHoldersForType(String typeName) throws ClassNotFoundException {
        Class<?> type = Class.forName(typeName);
        return SpringUtils.getSpringBeanHoldersForType(this.applicationContext, type);
    }

    public SpringBeanHolder[] getBeanHoldersForType(Class type) {
        return SpringUtils.getSpringBeanHoldersForType(this.applicationContext, type);
    }

    public SpringBeanHolder getBeanHolder(String beanName) {
        return SpringUtils.getSpringBeanHolder(this.applicationContext, beanName);
    }

    public String getSingletonObjectIdByName(String beanName) {
        return (String)this.singletonNameObjectIdMap.get((Object)beanName);
    }

    public String getBeanNameBySingletonObjectId(String objectId) throws NoSuchBeanDefinitionException {
        String beanName = null;
        beanName = (String)this.singletonNameObjectIdMap.inverseBidiMap().get((Object)objectId);
        if (beanName != null) {
            return beanName;
        }
        throw new NoSuchSingletonBeanException("No such singleton bean (object ID: " + objectId + ") is managed by Spring container.");
    }
}

