/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.webframe.velocity.runtime.resource.loader;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.StackObjectPool;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class BasicDataSourceResourceLoader
extends ResourceLoader {
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String tableName;
    private String keyColumn;
    private String templateColumn;
    private String timestampColumn;
    private DataSource dataSource;

    public void init(ExtendedProperties configuration) {
        this.driverClassName = configuration.getString("resource.driverClassName");
        this.url = configuration.getString("resource.url");
        this.username = configuration.getString("resource.username");
        this.password = configuration.getString("resource.password");
        this.tableName = configuration.getString("resource.table");
        this.keyColumn = configuration.getString("resource.keycolumn");
        this.templateColumn = configuration.getString("resource.templatecolumn");
        this.timestampColumn = configuration.getString("resource.timestampcolumn");
        RuntimeSingleton.info((Object)("Resources Loaded From: " + this.url + "/" + this.tableName));
        RuntimeSingleton.info((Object)("Resource Loader using columns: " + this.keyColumn + ", " + this.templateColumn + " and " + this.timestampColumn));
        RuntimeSingleton.info((Object)"Resource Loader Initalized.");
    }

    public boolean isSourceModified(Resource resource) {
        return resource.getLastModified() != this.readLastModified(resource, "checking timestamp");
    }

    public long getLastModified(Resource resource) {
        return this.readLastModified(resource, "getting timestamp");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (name == null || name.length() == 0) {
            throw new ResourceNotFoundException("Need to specify a template name!");
        }
        try {
            Connection conn = this.openDbConnection();
            try {
                block8: {
                    BufferedInputStream bufferedInputStream;
                    ResultSet rs = this.readData(conn, this.templateColumn, name);
                    try {
                        if (!rs.next()) break block8;
                        bufferedInputStream = new BufferedInputStream(rs.getAsciiStream(this.templateColumn));
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    Object var8_9 = null;
                    this.closeDbConnection(conn);
                    return bufferedInputStream;
                }
                String msg = "DataSourceResourceLoader Error: cannot find resource " + name;
                RuntimeSingleton.error((Object)msg);
                throw new ResourceNotFoundException(msg);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.closeDbConnection(conn);
                throw throwable;
            }
        }
        catch (Exception e) {
            String msg = "DataSourceResourceLoader Error: database problem trying to load resource " + name + ": " + e.toString();
            RuntimeSingleton.error((Object)msg);
            throw new ResourceNotFoundException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readLastModified(Resource resource, String i_operation) {
        String name = resource.getName();
        try {
            Connection conn = this.openDbConnection();
            try {
                ResultSet rs;
                block9: {
                    long l;
                    rs = this.readData(conn, this.timestampColumn, name);
                    try {
                        if (!rs.next()) break block9;
                        l = rs.getTimestamp(this.timestampColumn).getTime();
                        Object var6_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    Object var10_11 = null;
                    this.closeDbConnection(conn);
                    return l;
                }
                RuntimeSingleton.error((Object)("DataSourceResourceLoader Error: while " + i_operation + " could not find resource " + name));
                Object var6_10 = null;
                rs.close();
                Object var10_13 = null;
                this.closeDbConnection(conn);
                return 0L;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                this.closeDbConnection(conn);
                throw throwable;
            }
        }
        catch (Exception e) {
            RuntimeSingleton.error((Object)("DataSourceResourceLoader Error: error while " + i_operation + " when trying to load resource " + name + ": " + e.toString()));
        }
        return 0L;
    }

    private Connection openDbConnection() throws Exception {
        if (this.dataSource == null) {
            Class.forName(this.driverClassName);
            StackObjectPool pool = new StackObjectPool();
            DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(this.url, this.username, this.password);
            new PoolableConnectionFactory((ConnectionFactory)connFactory, (ObjectPool)pool, null, null, false, true);
            this.dataSource = new PoolingDataSource((ObjectPool)pool);
        }
        return this.dataSource.getConnection();
    }

    private void closeDbConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            RuntimeSingleton.info((Object)("DataSourceResourceLoader Quirk: problem when closing connection: " + e.toString()));
        }
    }

    private ResultSet readData(Connection conn, String columnNames, String templateName) throws SQLException {
        Statement stmt = conn.createStatement();
        String sql = "SELECT " + columnNames + " FROM " + this.tableName + " WHERE " + this.keyColumn + " = '" + templateName + "'";
        return stmt.executeQuery(sql);
    }
}

