/*  NDKmol - Molecular Viewer on Android NDK

     (C) Copyright 2011, biochem_fan

     This file is part of NDKmol.

     NDKmol is free software: you can redistribute it and/or modify
     it under the terms of the GNU Lesser General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU Lesser General Public License for more details.

     You should have received a copy of the GNU Lesser General Public License
     along with this program.  If not, see <http://www.gnu.org/licenses/>. */

package jp.sfjp.webglmol.NDKmol;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;

public class NdkView implements GLSurfaceView.Renderer  {
	public float objX, objY, objZ;
	public float cameraZ;
	public Quaternion rotationQ;
	public boolean isMoving = false;
	public int width, height;
	
	public int proteinMode = 0; // 0 - ribbon, 1 - trace
	public int hetatmMode = 2; // 0 - sphere, 1 - stick, 2 - line
	public boolean showSidechain = false;
	public boolean showUnitcell = false;
	public int symmetryMode = 0; // 0 - none, 1 - biomt, 2 - packing
	public int colorMode = 0; // 0 - chainbow, 1 - chain, 2 - ss
	
	private static native void nativeGLInit();
	private static native void nativeGLResize(int w, int h);
	private static native void nativeGLRender();
	private static native void nativeLoadProtein(String path);
	private static native void buildScene(int proteinMode, int hetatmMode, int symmetryMode, int colorMode, boolean showSidechain, boolean showUnitcell, boolean resetView);
 
	public NdkView() {
		objX = 0; objY = 0; objZ = 0;
		cameraZ = -300;
		rotationQ = new Quaternion(1, 0, 0, 0);
	} 
	
	public void prepareScene(boolean resetView) {
		buildScene(proteinMode, hetatmMode, symmetryMode, colorMode, showSidechain, showUnitcell, resetView);
	}

	public void onDrawFrame(GL10 gl) {
		gl.glClear(GL10.GL_COLOR_BUFFER_BIT|GL10.GL_DEPTH_BUFFER_BIT);
		
		gl.glMatrixMode(GL10.GL_MODELVIEW);
		gl.glLoadIdentity();
		gl.glTranslatef(0, 0, cameraZ);
		
		Vector3 axis = rotationQ.getAxis();
		gl.glRotatef(180 * rotationQ.getAngle() / (float)Math.PI, axis.x, axis.y, axis.z);
		
		gl.glTranslatef(objX, objY, objZ);
		
		nativeGLRender();
	}
 
	public void onSurfaceChanged(GL10 gl, int w, int h) {
		width = w; height = h;
		gl.glViewport(0, 0, width, height);
		gl.glMatrixMode(GL10.GL_PROJECTION);
		gl.glLoadIdentity();
		GLU.gluPerspective(gl, 20, (float)width / height, 1, 800);
		
		nativeGLResize(w, h);
	}

	public void onSurfaceCreated(GL10 gl, EGLConfig arg1) {
		nativeGLInit();
	}
	
	public void setProtein(String path) {
		nativeLoadProtein(path);	
		prepareScene(true);
	}
}
