/*  NDKmol - Molecular Viewer on Android NDK

     (C) Copyright 2011 - 2012, biochem_fan

     This file is part of NDKmol.

     NDKmol is free software: you can redistribute it and/or modify
     it under the terms of the GNU Lesser General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU Lesser General Public License for more details.

     You should have received a copy of the GNU Lesser General Public License
     along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#include "PLYGeometry.hpp"
#include "PDBReader.hpp"
#include "Geometry.hpp"
#include <cmath>
#include <fstream>
#include <iostream>
#include <cstdio>
#include <android/log.h>

// WARNING: This class supports ONLY files generated by EDTSurf
PLYGeometry::PLYGeometry(std::string filename): Renderable() {
	__android_log_print(ANDROID_LOG_DEBUG, "PLYGeometry","reading %s", filename.c_str());
	std::ifstream ifs(filename.c_str(), std::ios::in);

	//FIXME: error handling
	std::string line;
	int lineNo = 0;
	int vertexCount = 0, faceCount = 0;
	int vertexStart = 9999999, vertexEnd = 0, faceStart = 99999999, faceEnd = 0;
	int voffset = 0, foffset = 0, coffset = 0;
	int dummy, r, g, b;
	while (getline(ifs, line)) {
		if (lineNo >= vertexStart && lineNo <= vertexEnd) {
			sscanf(line.c_str(), "%f %f %f %d %d %d", vertexBuffer + (voffset++), vertexBuffer + (voffset++), vertexBuffer + (voffset++), &r, &g, &b);
			colorBuffer[coffset++] = r / (float)255;
			colorBuffer[coffset++] = g / (float)255;
			colorBuffer[coffset++] = b / (float)255;
			colorBuffer[coffset++] = 1.0;
		} else if (lineNo >= faceStart && lineNo <= faceEnd) {
			sscanf(line.c_str(), "%d %hd %hd %hd", &dummy, faceBuffer + (foffset++), faceBuffer + (foffset++), faceBuffer + (foffset++));
		} else if (lineNo == 3) {
			vertexCount = safeParseInt(line, 14, 10);
		} else if (lineNo == 10) {
			faceCount = safeParseInt(line, 13, 10);
			vertexBuffer = new float[vertexCount * 3];
			vertexNormalBuffer = new float[vertexCount * 3];
			colorBuffer = new float[vertexCount * 3 * 4];
			faceBuffer = new unsigned short[faceCount * 3];
			vertexColors = true;
			nFaces = faceCount * 3;
			vertexStart = 16; vertexEnd = vertexStart + vertexCount - 1;
			faceStart = 16 + vertexCount; faceEnd = faceStart + faceCount - 1;
			__android_log_print(ANDROID_LOG_DEBUG, "PLYGeometry","vertex %d face %d", vertexCount ,faceCount);
		}

		lineNo++;
	}
	ifs.close();


}

