/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui;

import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.core.publish.PublishDescriptionFactory;
import com.narucy.webpub.ui.WorkbenchTocAdapterFactory;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WebpubUIPlugin
extends AbstractUIPlugin {
    static WebpubUIPlugin plugin;
    public static final String ID_PLUGIN = "com.narucy.webpub";
    public static final String HT_PREVIEW_LINK_WITH_EDITOR = "ht_preview_link_with_editor";
    public static final String HT_PREVIEW_EXTENSIONS = "ht_preview_extensions";
    public static final String HT_EDITOR_DISPLAYED_TAB_WIDTH = "ht_editor_displayed_tab_editor";
    public static final String HT_EDITOR_WORDWRAP = "ht_editor_wordwrap";
    public static final String RUBY_INTERPRETER_LOCATION = "ruby_interpreter_location";
    public static final String IGNORE_PUBLISH_FILE_PATTERNS = "ignore_publish_file_pattern";
    public static final String HT_EDITOR_COLOR_BACKGROUND = "ht_editor_color_background";
    public static final String HT_EDITOR_COLOR_DEFAULT = "ht_editor_color_default";
    public static final String HT_EDITOR_COLOR_TAG = "ht_editor_color_tag";
    public static final String HT_EDITOR_COLOR_ATTR = "ht_editor_color_attr";
    public static final String HT_EDITOR_COLOR_COMMENT = "ht_editor_color_comment";
    public static final String HT_EDITOR_COLOR_ERB = "ht_editor_color_erb";
    public static final String HT_EDITOR_COLOR_PROCESSOR = "ht_editor_color_processor";
    public static final String HT_EDITOR_CONTENT_ASSIST = "ht_editor_content_assist";
    public static final String HT_EDITOR_CONTENT_ASSIST_DELAY = "ht_editor_content_assist_delay";
    public static final String TOCVIEW_FILES = "tocview_files";
    public static final String PUBLISH_CONSOLE_CHARSET = "publish_console_charset";
    WorkbenchTocAdapterFactory tocElementAdapterFactory = new WorkbenchTocAdapterFactory();
    ResourceBundle resourceBundle;
    URL imageBaseUrl;
    static /* synthetic */ Class class$0;

    public WebpubUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("webpubui");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        try {
            this.imageBaseUrl = new URL(WebpubUIPlugin.getDefault().getDescriptor().getInstallURL(), "icons/full/");
        }
        catch (MalformedURLException e) {
            WebpubUIPlugin.handleException(e);
        }
    }

    public static WebpubUIPlugin getDefault() {
        return plugin;
    }

    public static URL getResource(String path) {
        return WebpubUIPlugin.getDefault().getDescriptor().find((IPath)new Path(path));
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void handleException(Exception e) {
        e.printStackTrace();
        Object status = e instanceof CoreException ? ((CoreException)((Object)e)).getStatus() : new Status(4, ID_PLUGIN, 0, "Plug-in error", (Throwable)e);
        WebpubUIPlugin.getDefault().getLog().log(status);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(IGNORE_PUBLISH_FILE_PATTERNS, "CVS .publish");
        IPath rubyPath = WebpubPlugin.findInitialInterpreter();
        store.setDefault(RUBY_INTERPRETER_LOCATION, rubyPath != null ? rubyPath.toString() : "c:/ruby/bin/ruby.exe");
        store.setDefault(HT_PREVIEW_LINK_WITH_EDITOR, false);
        store.setDefault(HT_PREVIEW_EXTENSIONS, "html htm xml jpeg jpg gif png rd svg");
        store.setDefault(HT_EDITOR_DISPLAYED_TAB_WIDTH, 4);
        store.setDefault(HT_EDITOR_WORDWRAP, false);
        store.setDefault(HT_EDITOR_COLOR_BACKGROUND, "255,255,255");
        store.setDefault(HT_EDITOR_COLOR_DEFAULT, "0,0,0");
        store.setDefault(HT_EDITOR_COLOR_TAG, "0,0,127");
        store.setDefault(HT_EDITOR_COLOR_COMMENT, "0,127,0");
        store.setDefault(HT_EDITOR_COLOR_ERB, "127,127,127");
        store.setDefault(HT_EDITOR_COLOR_ATTR, "127,0,0");
        store.setDefault(HT_EDITOR_COLOR_PROCESSOR, "127,0,127");
        store.setDefault(HT_EDITOR_CONTENT_ASSIST, true);
        store.setDefault(HT_EDITOR_CONTENT_ASSIST_DELAY, 500);
        store.setDefault(TOCVIEW_FILES, "");
        store.setDefault(PUBLISH_CONSOLE_CHARSET, "UTF-8");
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String propName = event.getProperty();
                if (propName.equals(WebpubUIPlugin.IGNORE_PUBLISH_FILE_PATTERNS)) {
                    String[] patterns = StringConverter.asArray((String)((String)event.getNewValue()));
                    PublishDescriptionFactory.getInstance().setIgnorePatterns(patterns);
                } else if (propName.equals(WebpubUIPlugin.RUBY_INTERPRETER_LOCATION)) {
                    WebpubUIPlugin.this.refreshInterpreterLocation();
                }
            }
        });
        this.refreshInterpreterLocation();
    }

    void refreshInterpreterLocation() {
        IPreferenceStore store = this.getPreferenceStore();
        String location = store.getString(RUBY_INTERPRETER_LOCATION);
        if (location != null && location.length() > 0) {
            WebpubPlugin.getDefault().setRubyCommandPath((IPath)new Path(location));
        }
    }

    public static String join(String[] vals) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < vals.length) {
            buff.append(vals[i]);
            if (i != vals.length - 1) {
                buff.append(' ');
            }
            ++i;
        }
        return buff.toString();
    }

    public ImageDescriptor getImageDescriptor(String iconPath) {
        try {
            URL url = new URL(this.imageBaseUrl, iconPath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return WebpubUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        return WebpubUIPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static IViewPart findView(String id) {
        IWorkbenchPage page = WebpubUIPlugin.getActivePage();
        if (page != null) {
            return page.findView(id);
        }
        return null;
    }

    public String getRDTSelectedInterpreterLocation() {
        try {
            Plugin plugin = Platform.getPlugin((String)"org.rubypeople.rdt.launching");
            Class<?> klass = plugin.getClass().getClassLoader().loadClass("org.rubypeople.rdt.internal.launching.RubyRuntime");
            Method method = klass.getDeclaredMethod("getDefault", new Class[0]);
            Object rubyRuntime = method.invoke(klass, new Object[0]);
            Method getSelectedInterpreterMethod = rubyRuntime.getClass().getDeclaredMethod("getSelectedInterpreter", new Class[0]);
            Object rubyInterpreter = getSelectedInterpreterMethod.invoke(rubyRuntime, new Object[0]);
            Method getLocationMethod = rubyInterpreter.getClass().getDeclaredMethod("getCommand", new Class[0]);
            return (String)getLocationMethod.invoke(rubyInterpreter, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void startup() throws CoreException {
        IAdapterManager manager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.narucy.webpub.core.toc.Topic");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.tocElementAdapterFactory, (Class)clazz);
    }

    public void shutdown() throws CoreException {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.tocElementAdapterFactory);
    }

    void p(Object o) {
        System.out.println(((Object)((Object)this)).getClass() + ":" + o);
    }
}

