/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.actions;

import com.narucy.webpub.ui.WebpubUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RepublishAction
implements IWorkbenchWindowActionDelegate {
    IWorkbenchWindow window;
    ISelection selection;
    IWorkspaceRunnable republishProc = new IWorkspaceRunnable(){

        public void run(IProgressMonitor m) throws CoreException {
            IResource[] resources = RepublishAction.this.getSelectedResource();
            m.beginTask("Touch resource", resources.length * 2);
            try {
                int i = 0;
                while (i < resources.length && !m.isCanceled()) {
                    IResource r = resources[i];
                    r.touch((IProgressMonitor)new SubProgressMonitor(m, 1));
                    r.getProject().build(10, (IProgressMonitor)new SubProgressMonitor(m, 1));
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                m.done();
                throw throwable;
            }
            Object var5_7 = null;
            m.done();
        }
    };

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction act) {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ResourcesPlugin.getWorkspace().run(RepublishAction.this.republishProc, monitor);
                }
                catch (CoreException e) {
                    WebpubUIPlugin.handleException((Exception)((Object)e));
                }
            }
        };
        try {
            if (this.window != null) {
                this.window.run(true, true, operation);
            } else {
                operation.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (InvocationTargetException e) {
            WebpubUIPlugin.handleException(e);
        }
        catch (InterruptedException e) {
            WebpubUIPlugin.handleException(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        action.setEnabled(this.getSelectedResource().length > 0);
    }

    IResource[] getSelectedResource() {
        ArrayList<Object> resources = new ArrayList<Object>();
        if (this.selection instanceof IStructuredSelection && !this.selection.isEmpty()) {
            Object[] items = ((IStructuredSelection)this.selection).toArray();
            int i = 0;
            while (i < items.length) {
                if (items[i] instanceof IResource) {
                    resources.add(items[i]);
                }
                ++i;
            }
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public void dispose() {
    }
}

