/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.html;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.html.IRelativeResourceLinkChooser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

class CSSLink
implements IRelativeResourceLinkChooser {
    static Pattern cssLinkPattern = Pattern.compile("^<link\\s+.*rel=\"stylesheet\".*.*href=\"(.+\\.css)\".*\\s*");

    CSSLink() {
    }

    public IFile chooseLink(ITextEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                int i = 0;
                while (i < doc.getNumberOfLines()) {
                    String line = doc.get(doc.getLineOffset(i), doc.getLineLength(i));
                    Matcher match = cssLinkPattern.matcher(line);
                    if (match.matches()) {
                        IFile cssFile;
                        String path = match.group(1);
                        IFile htFile = ((IFileEditorInput)input).getFile();
                        if (path.charAt(0) == '/') {
                            path = path.substring(1);
                            IProject proj = htFile.getProject();
                            try {
                                WebProject wp = (WebProject)proj.getNature("com.narucy.webpub.core.publishNature");
                                cssFile = wp.getFolder("htsources_folder").getFile((IPath)new Path(path));
                            }
                            catch (CoreException coreException) {
                                cssFile = proj.getFile(path);
                            }
                        } else {
                            cssFile = htFile.getParent().getFile((IPath)new Path(path));
                        }
                        return cssFile;
                    }
                    ++i;
                }
            }
            catch (BadLocationException ex) {
                WebpubUIPlugin.handleException((Exception)((Object)ex));
            }
        }
        return null;
    }
}

