/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.html;

import com.narucy.webpub.core.template.Template;
import com.narucy.webpub.core.template.TemplateParseException;
import com.narucy.webpub.ui.WebpubUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IDecoratorManager;

class TemplateProvider
extends LabelProvider {
    Image tmplImage = null;

    synchronized void initImage() {
        WebpubUIPlugin plugin = WebpubUIPlugin.getDefault();
        this.tmplImage = plugin.getImageDescriptor("obj16/template.gif").createImage();
        IDecoratorManager decoratorManager = WebpubUIPlugin.getDefault().getWorkbench().getDecoratorManager();
        try {
            decoratorManager.setEnabled("com.narucy.webpub.ui.editors.ErrorDecorator", true);
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
    }

    public String getText(Object element) {
        if (element instanceof Template) {
            Template teml = (Template)element;
            return teml.getName();
        }
        if (element instanceof TemplateParseException) {
            TemplateParseException e = (TemplateParseException)((Object)element);
            return "Parse Error - " + e.getLineText();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (this.tmplImage == null) {
            this.initImage();
        }
        if (element instanceof Template) {
            return this.tmplImage;
        }
        if (element instanceof TemplateParseException) {
            return this.tmplImage;
        }
        return null;
    }

    public void dispose() {
        if (this.tmplImage != null) {
            this.tmplImage.dispose();
        }
    }
}

