/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.toc;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.TocFactory;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.toc.TocTextEditor;
import com.narucy.webpub.ui.editors.toc.TocTreeEditor;
import com.narucy.webpub.ui.editors.toc.TopicPropertySheetPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public class TocMultiPageEditor
extends MultiPageEditorPart {
    TopicPropertySheetPage propPage;
    Toc toc = null;
    TocTextEditor textEditor;
    TocTreeEditor treeEditor;
    static /* synthetic */ Class class$0;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid input:" + input);
        }
        IFile f = ((IFileEditorInput)input).getFile();
        try {
            this.toc = TocFactory.createToc((IFile)f);
        }
        catch (CoreException e) {
            throw new PartInitException(e.getStatus());
        }
        if (this.toc == null) {
            this.toc = new Toc(null, f.getFullPath().toString());
        }
        super.init(site, input);
    }

    protected void createPages() {
        try {
            this.treeEditor = new TocTreeEditor(this);
            this.addPage((IEditorPart)this.treeEditor, this.getEditorInput());
        }
        catch (PartInitException e) {
            this.addPage((Control)this.createErrorLabel(e));
        }
        this.setPageText(0, "Sitemap Tree");
        try {
            this.textEditor = new TocTextEditor(this);
            this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
        }
        catch (PartInitException e) {
            this.addPage((Control)this.createErrorLabel(e));
        }
        this.setPageText(1, "Source");
    }

    Label createErrorLabel(PartInitException e) {
        Label labe = new Label(this.getContainer(), 0);
        labe.setText(e.getMessage());
        return labe;
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(1).doSave(monitor);
        IFile f = ((IFileEditorInput)this.getEditorInput()).getFile();
        try {
            Toc projectToc;
            WebProject wp = (WebProject)f.getProject().getNature("com.narucy.webpub.core.publishNature");
            if (wp != null && (projectToc = wp.getToc(f)) != null) {
                projectToc.applyToc(this.toc);
                projectToc.fireChanged();
            }
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(1);
        editor.doSaveAs();
        this.setInput(editor.getEditorInput());
        this.setTitle(editor.getEditorInput().getName());
    }

    public boolean isDirty() {
        return this.getPageCount() > 0 ? this.getEditor(1).isDirty() : false;
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(1);
        this.getEditor(1).gotoMarker(marker);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            if (this.propPage == null) {
                this.propPage = new TopicPropertySheetPage();
            }
            return this.propPage;
        }
        return super.getAdapter(key);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void setInput(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            super.setInput(input);
            this.setTitle(input.getName());
        }
    }

    public Toc getToc() {
        return this.toc;
    }
}

