/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.toc;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.editors.toc.TocEditBlock;
import com.narucy.webpub.ui.editors.toc.TocMultiPageEditor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

class TocTreeEditor
extends EditorPart {
    final TocMultiPageEditor parentEditor;
    IContainer publishFolder;
    TocEditBlock block;
    Composite base;
    Label titleLabel;
    Color bgColor;
    Font titleFont;
    boolean dirty;

    public TocTreeEditor(TocMultiPageEditor parentEditor) {
        this.parentEditor = parentEditor;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        try {
            IProject proj = ((IFileEditorInput)input).getFile().getProject();
            WebProject wp = (WebProject)proj.getNature("com.narucy.webpub.core.publishNature");
            this.publishFolder = wp.getFolder("publish_folder");
        }
        catch (CoreException e) {
            throw new PartInitException(e.getStatus());
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Display disp = parent.getDisplay();
        this.bgColor = new Color((Device)disp, 255, 255, 255);
        FontData data = parent.getFont().getFontData()[0];
        this.titleFont = new Font((Device)disp, data.getName(), data.getHeight() * 3 / 2, 1);
        this.base = new Composite(parent, 0);
        this.base.setLayout((Layout)new GridLayout(1, true));
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TocTreeEditor.this.bgColor.dispose();
                TocTreeEditor.this.titleFont.dispose();
            }
        });
        this.titleLabel = new Label(this.base, 0);
        this.titleLabel.setLayoutData((Object)new GridData(768));
        this.titleLabel.setText("Sitemap");
        this.titleLabel.setFont(this.titleFont);
        this.block = new TocEditBlock(this.base);
        this.block.getControl().setLayoutData((Object)new GridData(1808));
        this.base.setBackground(this.bgColor);
        this.titleLabel.setBackground(this.bgColor);
        this.block.setBackground(this.bgColor);
        this.block.setInput(this.publishFolder, this.parentEditor.getToc());
        this.getSite().setSelectionProvider((ISelectionProvider)this.block.getTocTree());
    }

    void p(Object o) {
        System.out.println(((Object)((Object)this)).getClass() + ":" + o);
    }

    public void setFocus() {
    }

    public TocEditBlock getBlock() {
        return this.block;
    }

    public void dispose() {
        this.bgColor.dispose();
        this.titleFont.dispose();
        super.dispose();
    }
}

