/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.preferences;

import com.narucy.webpub.core.InterpreterCheckResult;
import com.narucy.webpub.core.InterpreterCheckerManager;
import com.narucy.webpub.ui.WebpubUIPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RubyInterpreterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String[] COLUMNS = new String[]{"Name", "Message", "State"};
    InterpreterCheckerManager checkerManager = InterpreterCheckerManager.getInstance();
    Button interpreterBrowseButton;
    Button useRdtInterpreterButton;
    Text interpreterLocation;
    Table infoTable;
    Text infoNote;
    IRunnableWithProgress checkProc = new IRunnableWithProgress(){

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                RubyInterpreterPreferencePage.this.setErrorMessage(null);
                RubyInterpreterPreferencePage.this.infoTable.removeAll();
                String path = RubyInterpreterPreferencePage.this.interpreterLocation.getText();
                try {
                    InterpreterCheckResult result = RubyInterpreterPreferencePage.this.checkerManager.check(path);
                    String[] keys = result.getKeys();
                    int i = 0;
                    while (i < keys.length) {
                        String k = keys[i];
                        String[] r = new String[]{k, result.getMessage(k), RubyInterpreterPreferencePage.toStateString(result.getState(k))};
                        new TableItem(RubyInterpreterPreferencePage.this.infoTable, 0).setText(r);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    RubyInterpreterPreferencePage.this.setErrorMessage(e.getLocalizedMessage());
                }
                TableColumn[] cols = RubyInterpreterPreferencePage.this.infoTable.getColumns();
                int i = 0;
                while (i < cols.length) {
                    cols[i].pack();
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                monitor.done();
                throw throwable;
            }
            Object var8_12 = null;
            monitor.done();
        }
    };

    protected Control createContents(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(768));
        base.setLayout((Layout)new GridLayout(1, false));
        this.createInterpreterSelectionControl(base);
        new Label(base, 0).setText("Ruby infomation:");
        this.infoTable = new Table(base, 68356);
        int i = 0;
        while (i < COLUMNS.length) {
            TableColumn col = new TableColumn(this.infoTable, 16384);
            col.setText(COLUMNS[i]);
            ++i;
        }
        this.infoTable.setLinesVisible(true);
        this.infoTable.setHeaderVisible(true);
        this.infoTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                String text = item.getText();
                String desc = RubyInterpreterPreferencePage.this.checkerManager.getDescription(text);
                RubyInterpreterPreferencePage.this.setNoteText(desc);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        this.infoTable.setLayoutData((Object)gd);
        this.infoNote = new Text(base, 524362);
        gd = new GridData(768);
        gd.heightHint = 100;
        this.infoNote.setLayoutData((Object)gd);
        this.load();
        return base;
    }

    Composite createInterpreterSelectionControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(3, false));
        base.setLayoutData((Object)new GridData(768));
        new Label(base, 0).setText("Interpreter:");
        this.interpreterLocation = new Text(base, 2048);
        this.interpreterLocation.setLayoutData((Object)new GridData(768));
        this.interpreterLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RubyInterpreterPreferencePage.this.interpreterCheck();
            }
        });
        this.interpreterBrowseButton = new Button(base, 8);
        this.interpreterBrowseButton.setText("&Browse...");
        this.interpreterBrowseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RubyInterpreterPreferencePage.this.callInterperterBrowseDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.interpreterBrowseButton.setLayoutData((Object)new GridData(256));
        new Label(base, 0);
        new Label(base, 0);
        this.useRdtInterpreterButton = new Button(base, 8);
        this.useRdtInterpreterButton.setText("Use &RDT Settings");
        this.useRdtInterpreterButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RubyInterpreterPreferencePage.this.useRdtInterpreterLocation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.useRdtInterpreterButton.setEnabled(WebpubUIPlugin.getDefault().getRDTSelectedInterpreterLocation() != null);
        this.useRdtInterpreterButton.setLayoutData((Object)new GridData(256));
        return base;
    }

    void callInterperterBrowseDialog() {
        String[] stringArray;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterNames(new String[]{"Ruby Interpreter"});
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "ruby.exe";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "ruby";
        }
        dialog.setFilterExtensions(stringArray);
        String file = dialog.open();
        if (file != null) {
            this.interpreterLocation.setText(file);
        }
    }

    void useRdtInterpreterLocation() {
        String path = WebpubUIPlugin.getDefault().getRDTSelectedInterpreterLocation();
        if (path != null) {
            this.interpreterLocation.setText(path);
        }
    }

    void setNoteText(String text) {
        this.infoNote.setText(text != null ? "Note: " + text : "");
    }

    void interpreterCheck() {
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, this.checkProc);
        }
        catch (InvocationTargetException e) {
            WebpubUIPlugin.handleException(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    static String toStateString(int v) {
        switch (v) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "Infomation";
            }
            case 2: {
                return "Warning";
            }
            case 3: {
                return "Error";
            }
        }
        throw new IllegalArgumentException("Invalid value:" + v);
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        String path = this.interpreterLocation.getText();
        store.setValue("ruby_interpreter_location", path);
        return true;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(WebpubUIPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.interpreterLocation.setText(store.getDefaultString("ruby_interpreter_location"));
    }

    void load() {
        IPreferenceStore store = this.getPreferenceStore();
        this.interpreterLocation.setText(store.getString("ruby_interpreter_location"));
    }
}

