/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.properties;

import com.narucy.webpub.ui.TableLabelProvider;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

class MapEditDialog
extends Dialog {
    static final String[] propNames = new String[]{"Key", "Value"};
    Map editTarget;
    String[] listProperties = new String[]{"key", "value"};
    int initialWidth = 400;
    int initialHeight = 300;
    TableViewer tableViewer;
    Button addButton;
    Button removeButton;

    public MapEditDialog(Shell shell, Map editTarget) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.editTarget = editTarget;
    }

    public Control createDialogArea(Composite parent) {
        Composite base = (Composite)super.createDialogArea(parent);
        base.setLayout((Layout)new GridLayout(2, false));
        new Label(base, 0).setText("Maps keys to values:");
        new Label(base, 0);
        this.tableViewer = new TableViewer(base, 68352);
        Table table = this.tableViewer.getTable();
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        table.setLayoutData((Object)gd);
        int i = 0;
        while (i < this.listProperties.length) {
            TableColumn col = new TableColumn(table, 16384);
            col.setText(propNames[i]);
            ++i;
        }
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.tableViewer.setColumnProperties(this.listProperties);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] keys = MapEditDialog.this.editTarget.keySet().toArray();
                Arrays.sort(keys);
                Object[] entryDatas = new Object[keys.length];
                int i = 0;
                while (i < keys.length) {
                    String k = (String)keys[i];
                    entryDatas[i] = new String[]{k, (String)MapEditDialog.this.editTarget.get(k)};
                    ++i;
                }
                return entryDatas;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                return ((String[])element)[columnIndex];
            }
        });
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                String[] kv = (String[])element;
                return kv[property.equals("key") ? 0 : 1];
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                String[] kv = (String[])element;
                if (property.equals("key")) {
                    MapEditDialog.this.editTarget.remove(kv[0]);
                    MapEditDialog.this.editTarget.put((String)value, kv[1]);
                } else {
                    MapEditDialog.this.editTarget.put(kv[0], (String)value);
                }
                MapEditDialog.this.tableViewer.refresh();
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MapEditDialog.this.refreshButtonStatus();
            }
        });
        this.tableViewer.setInput((Object)this.editTarget);
        TableColumn[] columns = table.getColumns();
        int i2 = 0;
        int minSize = this.initialWidth / 3;
        while (i2 < columns.length) {
            TableColumn column = columns[i2];
            column.pack();
            if (column.getWidth() < minSize) {
                column.setWidth(minSize);
            }
            ++i2;
        }
        TextCellEditor editor = new TextCellEditor((Composite)table);
        this.tableViewer.setCellEditors(new CellEditor[]{editor, editor});
        this.addButton = MapEditDialog.createButton(base, "&Add", new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MapEditDialog.this.callAddDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton = MapEditDialog.createButton(base, "&Remove", new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MapEditDialog.this.editTarget.remove(MapEditDialog.this.getCurrentSelection()[0]);
                MapEditDialog.this.tableViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refreshButtonStatus();
        return base;
    }

    static Button createButton(Composite base, String text, SelectionListener listener) {
        Button button = new Button(base, 8);
        button.setLayoutData((Object)new GridData(258));
        button.setText(text);
        button.addSelectionListener(listener);
        return button;
    }

    void refreshButtonStatus() {
        String[] value = this.getCurrentSelection();
        this.removeButton.setEnabled(value != null);
    }

    String[] getCurrentSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        return (String[])sel.getFirstElement();
    }

    void callAddDialog() {
        String newKey = null;
        InputDialog dialog = new InputDialog(this.getShell(), "New Item Entry", "Input key of new item", null, null);
        if (dialog.open() == 0 && (newKey = dialog.getValue()).length() > 0) {
            this.editTarget.put(newKey, "");
            this.tableViewer.refresh();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Key/Value");
    }

    protected Point getInitialSize() {
        return new Point(this.initialWidth, this.initialHeight);
    }
}

