/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.properties;

import com.narucy.webpub.core.publish.IllegalConfigurationException;
import com.narucy.webpub.core.publish.PublishDescription;
import com.narucy.webpub.core.publish.PublishDescriptionFactory;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.properties.PublishDescriptorDefinitionPage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class PublishDescriptionPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    PublishDescriptionFactory factory = PublishDescriptionFactory.getInstance();
    IResource targetResource;
    static /* synthetic */ Class class$0;

    Control createPublishDescriptorErrorControl(Composite parent, Exception e) {
        Label label = new Label(parent, 0);
        label.setText(e.toString());
        return label;
    }

    protected Control createContents(Composite parent) {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.targetResource = (IResource)iAdaptable.getAdapter((Class)clazz);
        try {
            PublishDescription desc = this.factory.create(this.targetResource);
            if (desc != null) {
                return this.createPublishInfo(desc, parent);
            }
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        catch (IllegalConfigurationException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        catch (IOException e) {
            WebpubUIPlugin.handleException(e);
        }
        return this.createNoPublishInfo(parent);
    }

    Control createNoPublishInfo(Composite parent) {
        Label labe = new Label(parent, 0);
        labe.setText("No Publish.");
        return labe;
    }

    Control createPublishInfo(PublishDescription desc, Composite parent) throws CoreException, IllegalConfigurationException, IOException {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(3, false));
        try {
            IFile descFile = this.targetResource instanceof IFile && this.factory.createFromFile((IFile)this.targetResource) != null ? (IFile)this.targetResource : this.factory.findPublishDescriptionFile(this.targetResource);
            this.createPublishDescriptorLocationInfo(base, descFile);
            this.createByInfo(base, desc.getPublishBy());
            this.createToInfo(base, desc.getPublishTo());
            this.createArgumentInfo(base, desc.getArguments());
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        return base;
    }

    void createArgumentInfo(Composite base, Map m) {
        new Label(base, 0).setText("Arguments:");
        Object[] ks = m.keySet().toArray();
        if (ks.length > 0) {
            Arrays.sort(ks);
            int j = 0;
            while (j < ks.length) {
                if (j != 0) {
                    new Label(base, 0);
                }
                String k = (String)ks[j];
                new Label(base, 0).setText(String.valueOf(k) + ":");
                new Label(base, 0).setText(m.get(k).toString());
                ++j;
            }
        }
    }

    void createByInfo(Composite base, String by) {
        this.createLineLabel(base, "Publish By", by);
    }

    void createPublishDescriptorLocationInfo(Composite base, final IFile pubDescFile) {
        boolean descFileExist = pubDescFile != null;
        String val = descFileExist ? pubDescFile.getFullPath().toString() : "(none)";
        this.createLineLabel(base, "Publish Descriptor Location", val);
        Button button = new Button(base, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        button.setLayoutData((Object)gd);
        button.setText("&Publish Descriptor Definication");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishDescriptorDefinitionPage.openPublishDescriptorDefinicationDialog(pubDescFile, PublishDescriptionPage.this.getShell());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        button.setEnabled(descFileExist && pubDescFile.getName().equals(".publish"));
    }

    void createLineLabel(Composite base, String name, String value) {
        new Label(base, 0).setText(String.valueOf(name) + ":");
        Label labe = new Label(base, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        labe.setLayoutData((Object)gd);
        labe.setText(value);
    }

    void createToInfo(Composite base, IResource to) {
        this.createLineLabel(base, "Publish To", to.getFullPath().toString());
    }
}

