/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.properties;

import com.narucy.webpub.core.StatusChangeListener;
import com.narucy.webpub.core.publish.IllegalConfigurationException;
import com.narucy.webpub.core.publish.PublishDescriptionFactory;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.properties.PublishDescriptorDifinicationBlock;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class PublishDescriptorDefinitionPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    IFile editTarget;
    Button noPublishButton;
    Button useParentButton;
    Button openParentButton;
    Button useCurrentButton;
    PublishDescriptorDifinicationBlock block;
    SelectionListener radioSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            PublishDescriptorDefinitionPage.this.refreshControls();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IFolder folder = (IFolder)iAdaptable.getAdapter((Class)clazz);
        this.editTarget = folder.getFile(".publish");
        boolean fileExist = this.editTarget.exists();
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(1, false));
        this.noPublishButton = this.createButton(base, "&No Publish");
        this.useParentButton = this.createButton(base, "Use &Parent Setting");
        this.openParentButton = new Button(base, 8);
        this.openParentButton.setText("&Open Parent Description");
        try {
            if (PublishDescriptionFactory.getInstance().create((IResource)folder) == null) {
                this.noPublishButton.setSelection(!fileExist);
                this.useParentButton.setEnabled(false);
                this.openParentButton.setEnabled(false);
            } else {
                this.useParentButton.setSelection(!fileExist);
                this.noPublishButton.setEnabled(false);
                final IFile parentPubDescFile = PublishDescriptionFactory.getInstance().findPublishDescriptionFile((IResource)folder);
                this.openParentButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        PublishDescriptorDefinitionPage.openPublishDescriptorDefinicationDialog(parentPubDescFile, PublishDescriptorDefinitionPage.this.getShell());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
        }
        catch (CoreException coreException) {
            this.openParentButton.setEnabled(false);
        }
        catch (IllegalConfigurationException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        catch (IOException e) {
            WebpubUIPlugin.handleException(e);
        }
        this.useCurrentButton = this.createButton(base, "Use &Current Folder Settings");
        this.useCurrentButton.setSelection(fileExist);
        this.block = new PublishDescriptorDifinicationBlock(base, this.editTarget, new StatusChangeListener(){

            public void statusChanged(IStatus status) {
                PublishDescriptorDefinitionPage.this.setErrorMessage(status.getSeverity() == 4 ? status.getMessage() : null);
            }
        });
        this.block.getControl().setLayoutData((Object)new GridData(1808));
        new Text(base, 74).setText("Note: If you selection parent setting, remove a publish description file of this folder.");
        this.refreshControls();
        return base;
    }

    void initButtonStatue() {
    }

    Button createButton(Composite base, String name) {
        Button button = new Button(base, 16);
        button.addSelectionListener(this.radioSelectionListener);
        button.setText(name);
        return button;
    }

    void refreshControls() {
        this.block.setEnabled(this.useCurrentButton.getSelection());
    }

    public static void openPublishDescriptorDefinicationDialog(final IFile pubDescFile, Shell parentShell) {
        Dialog dialog = new Dialog(parentShell){
            PublishDescriptorDifinicationBlock block;

            protected Point getInitialSize() {
                Point p = super.getInitialSize();
                return new Point((int)((double)p.x * 1.25), (int)((double)p.y * 1.5));
            }

            protected Control createDialogArea(Composite parent) {
                Composite base = (Composite)super.createDialogArea(parent);
                Shell newShell = base.getShell();
                newShell.setText("Publish Descriptor Definition - " + pubDescFile.getFullPath());
                base.setLayout((Layout)new FillLayout());
                this.block = new PublishDescriptorDifinicationBlock(base, pubDescFile, null);
                return base;
            }

            protected void okPressed() {
                try {
                    this.block.store();
                }
                catch (CoreException e) {
                    WebpubUIPlugin.handleException((Exception)((Object)e));
                }
                super.okPressed();
            }

            protected int getShellStyle() {
                return super.getShellStyle() | 0x400 | 0x10;
            }
        };
        dialog.open();
    }

    public Point computeSize() {
        return new Point(0, 0);
    }

    public boolean performOk() {
        super.performOk();
        try {
            if (this.useCurrentButton.getSelection()) {
                return this.block.store();
            }
            IFile target = this.block.getEditTarget();
            if (target != null && target.exists()) {
                target.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        return true;
    }
}

