/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.properties;

import com.narucy.webpub.core.StatusChangeListener;
import com.narucy.webpub.core.publish.PublishPropertyStore;
import com.narucy.webpub.core.publish.PublisherRegistory;
import com.narucy.webpub.ui.TableLabelProvider;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.properties.MapEditDialog;
import com.narucy.webpub.ui.properties.ResourceMatchDialog;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PublishDescriptorDifinicationBlock {
    static final String COLKEY_PATTERN = "pattern";
    static final String COLKEY_BY = "by";
    static final String COLKEY_PUBLISHTO = "publishTo";
    static final String COLKEY_ARGUMENTS = "arguments";
    static String[] specialAttributes = new String[]{"by", "publish_to"};
    static HashMap propertyNames = new HashMap();
    PublisherRegistory registory = PublisherRegistory.getInstance();
    String[] publishKeys;
    StatusChangeListener statusListener;
    DocumentBuilderFactory docBuilderFac = DocumentBuilderFactory.newInstance();
    Composite base;
    TableViewer publishDescriptionViewer;
    Button addDescItemButton;
    Button removeDescItemButton;
    Button upDescItemButton;
    Button downDescItemButton;
    Text publishDescriptionText;
    String[] columnProps = new String[]{"pattern", "by", "publishTo", "arguments"};
    IFile editTargetResource;

    static {
        propertyNames.put(COLKEY_PATTERN, "File Match Pattern");
        propertyNames.put(COLKEY_BY, "Publish By");
        propertyNames.put(COLKEY_PUBLISHTO, "Publish To");
        propertyNames.put(COLKEY_ARGUMENTS, "Arguments");
        Arrays.sort(specialAttributes);
    }

    public PublishDescriptorDifinicationBlock(Composite parent, IFile editTargetResource, StatusChangeListener statusListener) {
        this.publishKeys = this.registory.getPublishByKeys();
        Arrays.sort(this.publishKeys);
        this.editTargetResource = editTargetResource;
        this.statusListener = statusListener;
        this.base = new Composite(parent, 0);
        this.base.setLayout((Layout)new GridLayout(2, false));
        Label labe = new Label(this.base, 0);
        GridData gd = new GridData(768);
        labe.setLayoutData((Object)gd);
        labe.setText("Define publisher &mappings:");
        labe = new Label(this.base, 0);
        this.publishDescriptionViewer = new TableViewer(this.base, 68356);
        Table table = this.publishDescriptionViewer.getTable();
        gd = new GridData(1808);
        gd.verticalSpan = 4;
        table.setLayoutData((Object)gd);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.publishDescriptionViewer.setColumnProperties(this.columnProps);
        this.publishDescriptionViewer.setContentProvider((IContentProvider)new PublishDescriptionContentProvider());
        this.publishDescriptionViewer.setLabelProvider((IBaseLabelProvider)new PublishDescriptionLabelProvider());
        this.publishDescriptionViewer.setCellModifier((ICellModifier)new PublishDescriptionCellModifier());
        this.publishDescriptionViewer.setCellEditors(this.createCellEditors());
        int i = 0;
        while (i < this.columnProps.length) {
            String key = this.columnProps[i];
            TableColumn col = new TableColumn(table, 16384);
            col.setText((String)propertyNames.get(key));
            ++i;
        }
        this.addDescItemButton = PublishDescriptorDifinicationBlock.createButton(this.base, "&Add", new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishDescriptionsDocumentsFacade facade = (PublishDescriptionsDocumentsFacade)PublishDescriptorDifinicationBlock.this.publishDescriptionViewer.getInput();
                facade.addInitialPublishDescription(PublishDescriptorDifinicationBlock.this.getSelectedElement());
                PublishDescriptorDifinicationBlock.this.refreshAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeDescItemButton = PublishDescriptorDifinicationBlock.createButton(this.base, "&Remove", new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishDescriptorDifinicationBlock.this.getPublishDescriptionDocumentsFacade().removeElement(PublishDescriptorDifinicationBlock.this.getSelectedElement());
                PublishDescriptorDifinicationBlock.this.refreshAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.upDescItemButton = PublishDescriptorDifinicationBlock.createButton(this.base, "&Up", new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishDescriptorDifinicationBlock.this.getPublishDescriptionDocumentsFacade().moveElement(PublishDescriptorDifinicationBlock.this.getSelectedElement(), -1);
                PublishDescriptorDifinicationBlock.this.refreshAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.downDescItemButton = PublishDescriptorDifinicationBlock.createButton(this.base, "&Down", new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishDescriptorDifinicationBlock.this.getPublishDescriptionDocumentsFacade().moveElement(PublishDescriptorDifinicationBlock.this.getSelectedElement(), 1);
                PublishDescriptorDifinicationBlock.this.refreshAll();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(this.base, 0).setText("Publisher description:");
        new Label(this.base, 0);
        this.publishDescriptionText = new Text(this.base, 2890);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.publishDescriptionText.setLayoutData((Object)gd);
        this.publishDescriptionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PublishDescriptorDifinicationBlock.this.refreshPublishDescriptionText();
                PublishDescriptorDifinicationBlock.this.refreshButtonState();
            }
        });
        this.initContent();
    }

    public IFile getEditTarget() {
        return this.editTargetResource;
    }

    static boolean isSpecialAttribute(String name) {
        return Arrays.binarySearch(specialAttributes, name) >= 0;
    }

    int getColumnIndex(String name) {
        int i = 0;
        while (i < this.columnProps.length) {
            if (this.columnProps[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    CellEditor[] createCellEditors() {
        Table table = this.publishDescriptionViewer.getTable();
        CellEditor[] editors = new CellEditor[this.columnProps.length];
        int i = 0;
        while (i < this.columnProps.length) {
            String prop = this.columnProps[i];
            Object ed = prop.equals(COLKEY_PATTERN) ? new Fix34819iDialogCellEditor(table){

                Dialog createDialog(Control c) {
                    String pattern = (String)this.doGetValue();
                    return new ResourceMatchDialog(c.getShell(), pattern, PublishDescriptorDifinicationBlock.this.editTargetResource.getParent());
                }

                Object getResult(Dialog dialog) {
                    return ((ResourceMatchDialog)dialog).getFilter();
                }
            } : (prop.equals(COLKEY_BY) ? new ComboBoxCellEditor((Composite)table, this.publishKeys) : (prop.equals(COLKEY_PUBLISHTO) ? new TextCellEditor((Composite)table) : (prop.equals(COLKEY_ARGUMENTS) ? new Fix34819iDialogCellEditor(table){

                Dialog createDialog(Control c) {
                    return new MapEditDialog(c.getShell(), (Map)this.doGetValue());
                }

                Object getResult(Dialog dialog) {
                    return this.doGetValue();
                }
            } : null)));
            editors[i] = ed;
            ++i;
        }
        return editors;
    }

    void refreshAll() {
        this.publishDescriptionViewer.refresh();
        this.refreshButtonState();
        this.refreshPublishDescriptionText();
    }

    void refreshButtonState() {
        boolean enable = this.publishDescriptionViewer.getTable().getEnabled();
        Element selectedElem = this.getSelectedElement();
        PublishDescriptionsDocumentsFacade docFacade = this.getPublishDescriptionDocumentsFacade();
        int index = docFacade.nodeIndex(selectedElem);
        this.addDescItemButton.setEnabled(enable);
        this.removeDescItemButton.setEnabled(enable && selectedElem != null);
        this.upDescItemButton.setEnabled(enable && index >= 1);
        this.downDescItemButton.setEnabled(enable && index < docFacade.getDescriptionCount() - 1);
    }

    void refreshPublishDescriptionText() {
        Element mappingElem = this.getSelectedElement();
        if (mappingElem != null) {
            Element publishElem = (Element)mappingElem.getElementsByTagName("publish").item(0);
            String by = publishElem.getAttribute(COLKEY_BY);
            String description = this.registory.getPublishDescription(by);
            this.publishDescriptionText.setText(description != null ? description : "Specify publisher (" + by + ") is not exist description.");
        } else {
            this.publishDescriptionText.setText("");
        }
    }

    PublishDescriptionsDocumentsFacade getPublishDescriptionDocumentsFacade() {
        return (PublishDescriptionsDocumentsFacade)this.publishDescriptionViewer.getInput();
    }

    Element getSelectedElement() {
        IStructuredSelection sel = (IStructuredSelection)this.publishDescriptionViewer.getSelection();
        return !sel.isEmpty() ? (Element)sel.getFirstElement() : null;
    }

    static Button createButton(Composite parent, String title, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setText(title);
        button.setLayoutData((Object)new GridData(258));
        button.addSelectionListener(listener);
        return button;
    }

    void initContent() {
        String errorMessage = null;
        try {
            Document doc;
            DocumentBuilder docBuilder = this.docBuilderFac.newDocumentBuilder();
            if (this.editTargetResource.exists()) {
                doc = docBuilder.parse(this.editTargetResource.getContents());
            } else {
                URL url = WebpubUIPlugin.getResource("resources/inital_publish_description");
                doc = docBuilder.parse(url.openStream());
            }
            this.publishDescriptionViewer.setInput((Object)new PublishDescriptionsDocumentsFacade(doc));
        }
        catch (SAXException sAXException) {
            errorMessage = "configuration file \".publish\" is invalid.";
        }
        catch (IOException iOException) {
            errorMessage = "can not read \".publish\".";
        }
        catch (ParserConfigurationException e) {
            errorMessage = "publish file read error that is parser configuration exception.";
            WebpubUIPlugin.handleException(e);
        }
        catch (CoreException e) {
            errorMessage = "can not found publish configuration file \".publish\", (that file is not synchronize in workbench resource, or that file is not exist or not local)";
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        Table table = this.publishDescriptionViewer.getTable();
        int i = 0;
        int len = table.getColumnCount();
        while (i < len) {
            TableColumn col = table.getColumn(i);
            col.pack();
            if (col.getWidth() > 100) {
                col.setWidth(100);
            }
            ++i;
        }
        boolean enabled = errorMessage == null;
        this.setEnabled(enabled);
        if (this.statusListener != null) {
            if (!enabled) {
                this.statusListener.statusChanged(PublishDescriptorDifinicationBlock.createStatus(4, errorMessage));
            } else {
                this.statusListener.statusChanged(PublishDescriptorDifinicationBlock.createStatus(0, ""));
            }
        }
    }

    static IStatus createStatus(int severity, String message) {
        return new Status(severity, "com.narucy.webpub", severity, message, null);
    }

    public void setEnabled(boolean bool) {
        Control[] controls = this.base.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].setEnabled(bool);
            ++i;
        }
    }

    public boolean store() throws CoreException {
        PublishPropertyStore storer = new PublishPropertyStore();
        Document doc = this.getPublishDescriptionDocumentsFacade().getDocument();
        storer.store(this.editTargetResource.getLocation().toFile(), doc);
        this.editTargetResource.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        return true;
    }

    public Composite getControl() {
        return this.base;
    }

    static class PublishDescriptionsDocumentsFacade {
        Document doc;

        PublishDescriptionsDocumentsFacade(Document doc) {
            this.doc = doc;
        }

        int getDescriptionCount() {
            return this.getPublishElements().length;
        }

        int nodeIndex(Element e) {
            Element[] elems = this.getPublishElements();
            int i = 0;
            while (i < elems.length) {
                if (elems[i].equals(e)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        Element[] getPublishElements() {
            Element rootElem = this.doc.getDocumentElement();
            NodeList nodes = rootElem.getElementsByTagName("mapping");
            int len = nodes.getLength();
            Element[] elems = new Element[len];
            int i = 0;
            while (i < len) {
                elems[i] = (Element)nodes.item(i);
                ++i;
            }
            return elems;
        }

        void moveElement(Element moveTargetElem, int moveCount) {
            int index = this.nodeIndex(moveTargetElem);
            Element rootElem = this.doc.getDocumentElement();
            Element[] pubElems = this.getPublishElements();
            boolean upCmd = moveCount < 0;
            int i = 0;
            int j = upCmd ? index : index + 1;
            while (i < Math.abs(moveCount)) {
                if (upCmd) {
                    rootElem.insertBefore(moveTargetElem, pubElems[--j]);
                } else if (++j < pubElems.length) {
                    rootElem.insertBefore(moveTargetElem, pubElems[j]);
                } else {
                    rootElem.appendChild(moveTargetElem);
                }
                ++i;
            }
        }

        void removeElement(Element elem) {
            Element rootElem = this.doc.getDocumentElement();
            rootElem.removeChild(elem);
        }

        void addInitialPublishDescription() {
            this.addInitialPublishDescription(null);
        }

        void addInitialPublishDescription(Element insertBeforeElem) {
            Element rootElem = this.doc.getDocumentElement();
            Element newMappingElem = this.doc.createElement("mapping");
            newMappingElem.setAttribute(PublishDescriptorDifinicationBlock.COLKEY_PATTERN, "**/*");
            if (insertBeforeElem != null) {
                rootElem.insertBefore(newMappingElem, insertBeforeElem);
            } else {
                rootElem.appendChild(newMappingElem);
            }
            Element newPublishElem = this.doc.createElement("publish");
            newMappingElem.appendChild(newPublishElem);
            newPublishElem.setAttribute(PublishDescriptorDifinicationBlock.COLKEY_BY, "copy");
        }

        Document getDocument() {
            return this.doc;
        }
    }

    class PublishDescriptionContentProvider
    implements IStructuredContentProvider {
        PublishDescriptionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            PublishDescriptionsDocumentsFacade docFacade = (PublishDescriptionsDocumentsFacade)inputElement;
            return docFacade.getPublishElements();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class PublishDescriptionLabelProvider
    extends TableLabelProvider {
        PublishDescriptionLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            Element mappingElem = (Element)element;
            Element publishElem = (Element)mappingElem.getElementsByTagName("publish").item(0);
            switch (columnIndex) {
                case 0: {
                    return mappingElem.getAttribute(PublishDescriptorDifinicationBlock.COLKEY_PATTERN);
                }
                case 1: {
                    String by = publishElem.getAttribute(PublishDescriptorDifinicationBlock.COLKEY_BY);
                    return by;
                }
                case 2: {
                    String to = publishElem.getAttribute("publish_to");
                    return to != null && to.length() > 0 ? to : "(default)";
                }
                case 3: {
                    StringBuffer buff = new StringBuffer("{");
                    NamedNodeMap attrs = publishElem.getAttributes();
                    int i = 0;
                    int j = 0;
                    int len = attrs.getLength();
                    while (i < len) {
                        Node n = attrs.item(i);
                        String name = n.getNodeName();
                        if (!PublishDescriptorDifinicationBlock.isSpecialAttribute(name)) {
                            if (j++ > 0) {
                                buff.append(',');
                            }
                            buff.append(name);
                            buff.append('=');
                            buff.append(n.getNodeValue());
                        }
                        ++i;
                    }
                    buff.append('}');
                    return buff.toString();
                }
            }
            return "(" + columnIndex + " " + element.getClass().toString() + ")";
        }

        public boolean isLabelProperty(Object element, String property) {
            return PublishDescriptorDifinicationBlock.this.getColumnIndex(property) != -1;
        }
    }

    static abstract class Fix34819iDialogCellEditor
    extends DialogCellEditor {
        boolean dialogOpened = false;

        Fix34819iDialogCellEditor(Table table) {
            super((Composite)table);
        }

        protected void focusLost() {
            this.deactivate();
        }

        protected Button createButton(Composite parent) {
            Button dialogButton = super.createButton(parent);
            dialogButton.addListener(16, new Listener(this){
                final /* synthetic */ Fix34819iDialogCellEditor this$1;
                {
                    this.this$1 = fix34819iDialogCellEditor;
                }

                public void handleEvent(Event event) {
                    if (!this.this$1.dialogOpened) {
                        this.this$1.focusLost();
                    }
                }
            });
            return dialogButton;
        }

        protected final Object openDialogBox(Control parent) {
            this.dialogOpened = true;
            Dialog dialog = this.createDialog(parent);
            int res = dialog.open();
            this.dialogOpened = false;
            if (res == 0) {
                return this.getResult(dialog);
            }
            return null;
        }

        abstract Dialog createDialog(Control var1);

        abstract Object getResult(Dialog var1);
    }

    class PublishDescriptionCellModifier
    implements ICellModifier {
        PublishDescriptionCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return PublishDescriptorDifinicationBlock.this.getColumnIndex(property) != -1;
        }

        public Object getValue(Object element, String property) {
            Element mappingElem = (Element)element;
            if (property.equals(PublishDescriptorDifinicationBlock.COLKEY_PATTERN)) {
                return mappingElem.getAttribute(PublishDescriptorDifinicationBlock.COLKEY_PATTERN);
            }
            Element publishElem = (Element)mappingElem.getElementsByTagName("publish").item(0);
            if (property.equals(PublishDescriptorDifinicationBlock.COLKEY_PUBLISHTO)) {
                return publishElem.getAttribute("publish_to");
            }
            if (property.equals(PublishDescriptorDifinicationBlock.COLKEY_BY)) {
                String by = publishElem.getAttribute(PublishDescriptorDifinicationBlock.COLKEY_BY);
                int index = Arrays.binarySearch(PublishDescriptorDifinicationBlock.this.publishKeys, by);
                return new Integer(index);
            }
            if (property.equals(PublishDescriptorDifinicationBlock.COLKEY_ARGUMENTS)) {
                NamedNodeMap attrs = publishElem.getAttributes();
                HashMap<String, String> map = new HashMap<String, String>();
                int i = 0;
                int len = attrs.getLength();
                while (i < len) {
                    Node n = attrs.item(i);
                    String name = n.getNodeName();
                    if (!PublishDescriptorDifinicationBlock.isSpecialAttribute(name)) {
                        map.put(name, n.getNodeValue());
                    }
                    ++i;
                }
                return map;
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                element = ((TableItem)element).getData();
            }
            Element mappingElem = (Element)element;
            Element pubElem = (Element)mappingElem.getElementsByTagName("publish").item(0);
            if (property.equals(PublishDescriptorDifinicationBlock.COLKEY_PATTERN)) {
                mappingElem.setAttribute(PublishDescriptorDifinicationBlock.COLKEY_PATTERN, (String)value);
            } else if (property.equals(PublishDescriptorDifinicationBlock.COLKEY_BY)) {
                int index = (Integer)value;
                pubElem.setAttribute(PublishDescriptorDifinicationBlock.COLKEY_BY, PublishDescriptorDifinicationBlock.this.publishKeys[index]);
            } else if (property.equals(PublishDescriptorDifinicationBlock.COLKEY_PUBLISHTO)) {
                pubElem.setAttribute("publish_to", (String)value);
            } else if (property.equals(PublishDescriptorDifinicationBlock.COLKEY_ARGUMENTS)) {
                NamedNodeMap nm = pubElem.getAttributes();
                int i = 0;
                while (i < nm.getLength()) {
                    Node n = nm.item(i);
                    String name = n.getNodeName();
                    if (!PublishDescriptorDifinicationBlock.isSpecialAttribute(name)) {
                        pubElem.removeAttribute(name);
                    }
                    ++i;
                }
                Map newAttributes = (Map)value;
                Object[] keys = newAttributes.keySet().toArray();
                int i2 = 0;
                while (i2 < keys.length) {
                    String name = (String)keys[i2];
                    pubElem.setAttribute(name, (String)newAttributes.get(name));
                    ++i2;
                }
            }
            PublishDescriptorDifinicationBlock.this.publishDescriptionViewer.refresh();
        }
    }
}

