/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.properties;

import com.narucy.webpub.core.Wildcard;
import com.narucy.webpub.ui.WebpubUIPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceMatchDialog
extends TwoPaneElementSelector {
    String initialPattern;
    String baseMessage = "&Resource match (? = any charactor, * = any string, ** = any directory):";
    String errorMessage = null;
    Label messageLabel;
    IContainer workingContainer;
    Button useRegexp;

    static ILabelProvider createLabelProvider(final IContainer workingContainer) {
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider(){

            protected String decorateText(String input, Object element) {
                IResource res = (IResource)element;
                return ResourceMatchDialog.getRelativePath(res, workingContainer);
            }
        };
        IDecoratorManager decoratorManager = WebpubUIPlugin.getDefault().getWorkbench().getDecoratorManager();
        return new DecoratingLabelProvider((ILabelProvider)labelProvider, decoratorManager.getLabelDecorator());
    }

    static String getRelativePath(IResource target, IContainer base) {
        String fullPath = base.getFullPath().toString();
        int dirIndex = fullPath.length();
        String relPath = target.getFullPath().toString().substring(dirIndex);
        if (relPath.length() > 0 && relPath.charAt(0) == '/') {
            relPath = relPath.substring(1);
        }
        if (target instanceof IFolder) {
            relPath = String.valueOf(relPath) + '/';
        }
        return relPath;
    }

    static ILabelProvider createQualifierLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        };
    }

    public ResourceMatchDialog(Shell parent, String initialPattern, IContainer workingContainer) {
        super(parent, ResourceMatchDialog.createLabelProvider(workingContainer), ResourceMatchDialog.createQualifierLabelProvider());
        this.initialPattern = initialPattern;
        this.workingContainer = workingContainer;
        try {
            this.setElements(this.getAllTargetMembers());
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        this.setTitle("Matching Resources");
        this.setMessage(this.baseMessage);
        this.setUpperListLabel("Match resources");
        this.setLowerListLabel("Resource full description");
        String ptn = this.isInitialPatternUseRegexp() ? initialPattern.substring(1, initialPattern.length() - 1) : initialPattern;
        this.setFilter(ptn);
    }

    boolean isInitialPatternUseRegexp() {
        return this.initialPattern.charAt(0) == '/' && this.initialPattern.charAt(this.initialPattern.length() - 1) == '/';
    }

    IResource[] getAllTargetMembers() throws CoreException {
        ArrayList list = new ArrayList();
        ResourceMatchDialog.doFindMembers(this.workingContainer, list);
        return list.toArray(new IResource[list.size()]);
    }

    static void doFindMembers(IContainer container, List list) throws CoreException {
        IResource[] members = container.members();
        int i = 0;
        while (i < members.length) {
            IResource r = members[i];
            list.add(r);
            if (r instanceof IContainer) {
                ResourceMatchDialog.doFindMembers((IContainer)r, list);
            }
            ++i;
        }
    }

    protected Text createFilterText(Composite parent) {
        Text text = super.createFilterText(parent);
        this.useRegexp = new Button(parent, 32);
        this.useRegexp.setText("Use Regular Expression");
        this.useRegexp.setSelection(this.isInitialPatternUseRegexp());
        this.useRegexp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ResourceMatchDialog.this.setFilter(ResourceMatchDialog.this.getFilter());
                ResourceMatchDialog.this.handleSelectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return text;
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList list = super.createFilteredList(parent);
        list.setFilterMatcher((FilteredList.FilterMatcher)new WildcardMatcher());
        return list;
    }

    protected Label createMessageArea(Composite composite) {
        this.messageLabel = super.createMessageArea(composite);
        return this.messageLabel;
    }

    class WildcardMatcher
    implements FilteredList.FilterMatcher {
        Pattern pattern;
        Wildcard wildcard;

        WildcardMatcher() {
        }

        public void setFilter(String ptn, boolean ignoreCase, boolean ignoreWildCards) {
            this.pattern = null;
            this.wildcard = null;
            ResourceMatchDialog.this.errorMessage = null;
            try {
                if (ResourceMatchDialog.this.useRegexp.getSelection()) {
                    this.pattern = Pattern.compile(ptn);
                } else {
                    this.wildcard = new Wildcard(ptn);
                }
                ResourceMatchDialog.this.errorMessage = null;
            }
            catch (PatternSyntaxException e) {
                ResourceMatchDialog.this.errorMessage = "Pattern syntax error (" + ptn + "):" + e.getMessage();
            }
            ResourceMatchDialog.this.messageLabel.setText(ResourceMatchDialog.this.errorMessage != null ? ResourceMatchDialog.this.errorMessage.replaceAll("\n", "\\n") : ResourceMatchDialog.this.baseMessage);
        }

        public boolean match(Object element) {
            IResource res = (IResource)element;
            String relPath = ResourceMatchDialog.getRelativePath(res, ResourceMatchDialog.this.workingContainer);
            boolean match = ResourceMatchDialog.this.errorMessage == null && (this.pattern != null && this.pattern.matcher(relPath).matches() || this.wildcard != null && this.wildcard.match(relPath));
            return match;
        }
    }
}

